/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftbquests.net.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Movable;
import com.feed_the_beast.ftbquests.quest.QuestShape;
import com.feed_the_beast.ftbquests.util.NetUtils;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigString;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigValue;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ChapterImage
implements Movable {
    public Chapter chapter;
    public double x;
    public double y;
    public double width;
    public double height;
    public double rotation;
    public Icon image;
    public List<String> hover;
    public String click;
    public boolean dev;

    public ChapterImage(Chapter c) {
        this.chapter = c;
        this.y = 0.0;
        this.x = 0.0;
        this.width = 1.0;
        this.height = 1.0;
        this.rotation = 0.0;
        this.image = Icon.getIcon((String)"minecraft:textures/gui/presets/isles.png");
        this.hover = new ArrayList<String>();
        this.click = "";
        this.dev = false;
    }

    public void writeData(CompoundNBT nbt) {
        nbt.func_74780_a("x", this.x);
        nbt.func_74780_a("y", this.y);
        nbt.func_74780_a("width", this.width);
        nbt.func_74780_a("height", this.height);
        nbt.func_74780_a("rotation", this.rotation);
        nbt.func_74778_a("image", this.image.toString());
        ListNBT hoverTag = new ListNBT();
        for (String s : this.hover) {
            hoverTag.add((Object)StringNBT.func_229705_a_((String)s));
        }
        nbt.func_218657_a("hover", (INBT)hoverTag);
        nbt.func_74778_a("click", this.click);
        nbt.func_74757_a("dev", this.dev);
    }

    public void readData(CompoundNBT nbt) {
        this.x = nbt.func_74769_h("x");
        this.y = nbt.func_74769_h("y");
        this.width = nbt.func_74769_h("width");
        this.height = nbt.func_74769_h("height");
        this.rotation = nbt.func_74769_h("rotation");
        this.image = Icon.getIcon((String)nbt.func_74779_i("image"));
        this.hover.clear();
        ListNBT hoverTag = nbt.func_150295_c("hover", 8);
        for (int i = 0; i < hoverTag.size(); ++i) {
            this.hover.add(hoverTag.func_150307_f(i));
        }
        this.click = nbt.func_74779_i("click");
        this.dev = nbt.func_74767_n("dev");
    }

    public void writeNetData(PacketBuffer buffer) {
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.width);
        buffer.writeDouble(this.height);
        buffer.writeDouble(this.rotation);
        NetUtils.writeIcon(buffer, this.image);
        NetUtils.writeStrings(buffer, this.hover);
        buffer.func_180714_a(this.click);
        buffer.writeBoolean(this.dev);
    }

    public void readNetData(PacketBuffer buffer) {
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.width = buffer.readDouble();
        this.height = buffer.readDouble();
        this.rotation = buffer.readDouble();
        this.image = NetUtils.readIcon(buffer);
        NetUtils.readStrings(buffer, this.hover);
        this.click = buffer.func_218666_n();
        this.dev = buffer.readBoolean();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        config.addDouble("x", this.x, v -> {
            this.x = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("y", this.y, v -> {
            this.y = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("width", this.width, v -> {
            this.width = v;
        }, 1.0, 0.0, Double.POSITIVE_INFINITY);
        config.addDouble("height", this.height, v -> {
            this.height = v;
        }, 1.0, 0.0, Double.POSITIVE_INFINITY);
        config.addDouble("rotation", this.rotation, v -> {
            this.rotation = v;
        }, 0.0, -180.0, 180.0);
        config.addString("image", this.image.toString(), v -> {
            this.image = Icon.getIcon((String)v);
        }, "minecraft:textures/gui/presets/isles.png");
        config.addList("hover", this.hover, (ConfigValue)new ConfigString(), (Object)"");
        config.addString("click", this.click, v -> {
            this.click = v;
        }, "");
        config.addBool("dev", this.dev, v -> {
            this.dev = v;
        }, false);
    }

    @Override
    public Chapter getChapter() {
        return this.chapter;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public String getShape() {
        return "square";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void move(Chapter to, double _x, double _y) {
        this.x = _x;
        this.y = _y;
        if (to != this.chapter) {
            this.chapter.images.remove(this);
            new MessageEditObject(this.chapter).sendToServer();
            this.chapter = to;
            this.chapter.images.add(this);
        }
        new MessageEditObject(this.chapter).sendToServer();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMoved(MatrixStack matrixStack) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)this.rotation));
        matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
        this.image.withColor(Color4I.WHITE.withAlpha(50)).draw(matrixStack, -1, -1, 2, 2);
        matrixStack.func_227865_b_();
        QuestShape.get((String)this.getShape()).outline.withColor(Color4I.WHITE.withAlpha(30)).draw(matrixStack, 0, 0, 1, 1);
    }
}

