/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.MessageClaimRewardResponse;
import com.feed_the_beast.ftbquests.net.MessageSyncEditingMode;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardAutoClaim;
import com.feed_the_beast.ftbquests.quest.reward.RewardClaimType;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.util.OrderedCompoundNBT;
import it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IWorld;

public class PlayerData {
    public final QuestFile file;
    public final UUID uuid;
    public String name;
    public boolean shouldSave;
    private final Int2ObjectOpenHashMap<TaskData> taskData;
    private final IntOpenHashSet claimedRewards;
    private boolean canEdit;
    private long money;
    private boolean autoPin;
    public final IntOpenHashSet pinnedQuests;
    private Int2ByteOpenHashMap progressCache;
    private Int2ByteOpenHashMap areDependenciesCompleteCache;

    public static PlayerData get(PlayerEntity player) {
        return FTBQuests.PROXY.getQuestFile((IWorld)player.func_130014_f_()).getData((Entity)player);
    }

    public PlayerData(QuestFile f, UUID id) {
        this.file = f;
        this.uuid = id;
        this.name = "";
        this.shouldSave = false;
        this.taskData = new Int2ObjectOpenHashMap();
        this.claimedRewards = new IntOpenHashSet();
        this.canEdit = false;
        this.money = 0L;
        this.autoPin = false;
        this.pinnedQuests = new IntOpenHashSet();
    }

    public void save() {
        this.shouldSave = true;
    }

    public TaskData getTaskData(Task task) {
        TaskData d = (TaskData)this.taskData.get(task.id);
        if (d == null) {
            throw new NullPointerException("Task data null! Task: " + task + ", Quest: " + task.quest.chapter.filename + ":" + task.quest + ", Player: " + this.name);
        }
        return d;
    }

    public void createTaskData(Task task, boolean strong) {
        if (strong || !this.taskData.containsKey(task.id)) {
            this.taskData.put(task.id, (Object)task.createData(this));
        }
    }

    public void removeTaskData(Task task) {
        this.taskData.remove(task.id);
    }

    public boolean isRewardClaimed(int id) {
        return this.claimedRewards.contains(id);
    }

    public boolean setRewardClaimed(int id, boolean claimed) {
        if (claimed ? this.claimedRewards.add(id) : this.claimedRewards.remove(id)) {
            this.save();
            return true;
        }
        return false;
    }

    public boolean getCanEdit() {
        return this.canEdit;
    }

    public boolean setCanEdit(boolean mode) {
        if (this.canEdit != mode) {
            ServerPlayerEntity player;
            this.canEdit = mode;
            this.save();
            if (this.file.getSide().isServer() && (player = this.getPlayer()) != null) {
                new MessageSyncEditingMode(this.canEdit).sendTo(player);
            }
            return true;
        }
        return false;
    }

    public long getMoney() {
        return this.money;
    }

    public void setMoney(long value) {
        long m = Math.max(0L, value);
        if (this.money != m) {
            this.money = m;
            this.save();
        }
    }

    public boolean getAutoPin() {
        return this.autoPin;
    }

    public void setAutoPin(boolean auto) {
        if (this.autoPin != auto) {
            this.autoPin = auto;
            this.save();
        }
    }

    public boolean isQuestPinned(int id) {
        return this.pinnedQuests.contains(id);
    }

    public void setQuestPinned(int id, boolean pinned) {
        if (pinned ? this.pinnedQuests.add(id) : this.pinnedQuests.remove(id)) {
            this.save();
        }
    }

    public void clearCache() {
        this.progressCache = null;
        this.areDependenciesCompleteCache = null;
    }

    public CompoundNBT serializeNBT() {
        OrderedCompoundNBT nbt = new OrderedCompoundNBT();
        nbt.func_74778_a("uuid", this.uuid.toString());
        nbt.func_74778_a("name", this.name);
        nbt.func_74757_a("can_edit", this.canEdit);
        nbt.func_74772_a("money", this.money);
        nbt.func_74757_a("auto_pin", this.autoPin);
        OrderedCompoundNBT taskDataNBT = new OrderedCompoundNBT();
        ArrayList<TaskData> taskDataList = new ArrayList<TaskData>((Collection<TaskData>)this.taskData.values());
        taskDataList.sort(Comparator.comparingInt(o -> ((Task)o.task).id));
        for (TaskData data : taskDataList) {
            if (data.progress <= 0L) continue;
            if (data.progress <= Integer.MAX_VALUE) {
                taskDataNBT.func_74768_a(QuestObjectBase.getCodeString(data.task), (int)data.progress);
                continue;
            }
            taskDataNBT.func_74772_a(QuestObjectBase.getCodeString(data.task), data.progress);
        }
        nbt.func_218657_a("task_progress", (INBT)taskDataNBT);
        int[] claimedRewardsArray = this.claimedRewards.toIntArray();
        Arrays.sort(claimedRewardsArray);
        nbt.func_74783_a("claimed_rewards", claimedRewardsArray);
        int[] pinnedQuestsArray = this.pinnedQuests.toIntArray();
        Arrays.sort(pinnedQuestsArray);
        nbt.func_74783_a("pinned_quests", pinnedQuestsArray);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.name = nbt.func_74779_i("name");
        this.canEdit = nbt.func_74767_n("can_edit");
        this.money = nbt.func_74763_f("money");
        this.autoPin = nbt.func_74767_n("auto_pin");
        CompoundNBT taskDataNBT = nbt.func_74775_l("task_progress");
        for (String s : taskDataNBT.func_150296_c()) {
            Task task = this.file.getTask(this.file.getID(s));
            if (task == null) continue;
            ((TaskData)this.taskData.get(task.id)).readProgress(taskDataNBT.func_74763_f(s));
        }
        this.claimedRewards.clear();
        this.claimedRewards.addAll((IntCollection)new IntOpenHashSet(nbt.func_74759_k("claimed_rewards")));
        this.pinnedQuests.clear();
        this.pinnedQuests.addAll((IntCollection)new IntOpenHashSet(nbt.func_74759_k("pinned_quests")));
    }

    public void write(PacketBuffer buffer, boolean self) {
        buffer.func_211400_a(this.name, Short.MAX_VALUE);
        buffer.func_179254_b(this.money);
        int tds = 0;
        for (TaskData t : this.taskData.values()) {
            if (t.progress <= 0L) continue;
            ++tds;
        }
        buffer.func_150787_b(tds);
        for (TaskData t : this.taskData.values()) {
            if (t.progress <= 0L) continue;
            buffer.func_150787_b(((Task)t.task).id);
            buffer.func_179254_b(t.progress);
        }
        if (self) {
            buffer.func_150787_b(this.claimedRewards.size());
            ObjectIterator objectIterator = this.claimedRewards.iterator();
            while (objectIterator.hasNext()) {
                int i = (Integer)objectIterator.next();
                buffer.func_150787_b(i);
            }
            buffer.writeBoolean(this.canEdit);
            buffer.writeBoolean(this.autoPin);
            buffer.func_150787_b(this.pinnedQuests.size());
            for (Integer reward : this.pinnedQuests) {
                buffer.func_150787_b(reward.intValue());
            }
        }
    }

    public void read(PacketBuffer buffer, boolean self) {
        this.name = buffer.func_150789_c(Short.MAX_VALUE);
        this.money = buffer.func_179260_f();
        int ts = buffer.func_150792_a();
        for (int i = 0; i < ts; ++i) {
            TaskData t = (TaskData)this.taskData.get(buffer.func_150792_a());
            long progress = buffer.func_179260_f();
            if (t == null) continue;
            t.progress = progress;
        }
        this.claimedRewards.clear();
        this.canEdit = false;
        this.autoPin = false;
        this.pinnedQuests.clear();
        if (self) {
            int crs = buffer.func_150792_a();
            for (int i = 0; i < crs; ++i) {
                this.claimedRewards.add(buffer.func_150792_a());
            }
            this.canEdit = buffer.readBoolean();
            this.autoPin = buffer.readBoolean();
            int pqs = buffer.func_150792_a();
            for (int i = 0; i < pqs; ++i) {
                this.pinnedQuests.add(buffer.func_150792_a());
            }
        }
    }

    public int getRelativeProgress(QuestObject object) {
        int i;
        if (!object.cacheProgress()) {
            return object.getRelativeProgressFromChildren(this);
        }
        if (this.progressCache == null) {
            this.progressCache = new Int2ByteOpenHashMap();
            this.progressCache.defaultReturnValue((byte)-1);
        }
        if ((i = this.progressCache.get(object.id)) == -1) {
            i = object.getRelativeProgressFromChildren(this);
            this.progressCache.put(object.id, (byte)i);
        }
        return i;
    }

    public boolean isStarted(QuestObject object) {
        return this.getRelativeProgress(object) > 0;
    }

    public boolean isComplete(QuestObject object) {
        return this.getRelativeProgress(object) >= 100;
    }

    public boolean areDependenciesComplete(Quest quest) {
        byte b;
        if (quest.dependencies.isEmpty()) {
            return true;
        }
        if (this.areDependenciesCompleteCache == null) {
            this.areDependenciesCompleteCache = new Int2ByteOpenHashMap();
            this.areDependenciesCompleteCache.defaultReturnValue((byte)-1);
        }
        if ((b = this.areDependenciesCompleteCache.get(quest.id)) == -1) {
            b = this.areDependenciesComplete0(quest) ? (byte)1 : 0;
            this.areDependenciesCompleteCache.put(quest.id, b);
        }
        return b == 1;
    }

    private boolean areDependenciesComplete0(Quest quest) {
        if (quest.minRequiredDependencies > 0) {
            int complete = 0;
            for (QuestObject dependency : quest.dependencies) {
                if (dependency.invalid || !this.isComplete(dependency) || ++complete < quest.minRequiredDependencies) continue;
                return true;
            }
            return false;
        }
        if (quest.dependencyRequirement.one) {
            for (QuestObject object : quest.dependencies) {
                if (object.invalid || !(quest.dependencyRequirement.completed ? this.isComplete(object) : this.isStarted(object))) continue;
                return true;
            }
            return false;
        }
        for (QuestObject object : quest.dependencies) {
            if (object.invalid || !(quest.dependencyRequirement.completed ? !this.isComplete(object) : !this.isStarted(object))) continue;
            return false;
        }
        return true;
    }

    public boolean canStartTasks(Quest quest) {
        return this.areDependenciesComplete(quest);
    }

    public boolean hasUnclaimedRewards() {
        for (Chapter chapter : this.file.chapters) {
            if (!this.hasUnclaimedRewards(chapter)) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnclaimedRewards(Chapter chapter) {
        for (Quest quest : chapter.quests) {
            if (!this.hasUnclaimedRewards(quest)) continue;
            return true;
        }
        for (Chapter chapter1 : chapter.getChildren()) {
            if (!this.hasUnclaimedRewards(chapter1)) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnclaimedRewards(Quest quest) {
        if (this.isComplete(quest)) {
            for (Reward reward : quest.rewards) {
                if (this.getClaimType(reward) != RewardClaimType.CAN_CLAIM) continue;
                return true;
            }
        }
        return false;
    }

    public void claimReward(ServerPlayerEntity player, Reward reward, boolean notify) {
        if (this.setRewardClaimed(reward.id, true)) {
            reward.claim(player, notify);
            if (this.file.getSide().isServer()) {
                new MessageClaimRewardResponse(this.uuid, reward.id, 1).sendToAll();
            }
        }
    }

    @Nullable
    public ServerPlayerEntity getPlayer() {
        return ((ServerQuestFile)this.file).server.func_184103_al().func_177451_a(this.uuid);
    }

    public List<ServerPlayerEntity> getOnlineMembers() {
        ServerPlayerEntity playerEntity = this.getPlayer();
        if (playerEntity != null) {
            return Collections.singletonList(playerEntity);
        }
        return Collections.emptyList();
    }

    public void checkAutoCompletion(Quest quest) {
        if (quest.rewards.isEmpty() || !this.isComplete(quest)) {
            return;
        }
        List<ServerPlayerEntity> online = null;
        for (Reward reward : quest.rewards) {
            RewardAutoClaim auto = reward.getAutoClaimType();
            if (auto == RewardAutoClaim.DISABLED) continue;
            if (online == null && (online = this.getOnlineMembers()).isEmpty()) {
                return;
            }
            for (ServerPlayerEntity player : online) {
                this.claimReward(player, reward, auto == RewardAutoClaim.ENABLED);
            }
        }
    }

    public RewardClaimType getClaimType(Reward reward) {
        boolean r = this.isRewardClaimed(reward.id);
        if (r) {
            return RewardClaimType.CLAIMED;
        }
        if (this.isComplete(reward.quest)) {
            return RewardClaimType.CAN_CLAIM;
        }
        return RewardClaimType.CANT_CLAIM;
    }
}

