/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.client.FTBQuestsClient;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.gui.quests.GuiQuests;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.net.MessageMoveQuest;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.DependencyRequirement;
import com.feed_the_beast.ftbquests.quest.Movable;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestShape;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import com.feed_the_beast.ftbquests.util.NetUtils;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigString;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigValue;
import com.feed_the_beast.mods.ftbguilibrary.config.Tristate;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.IconAnimation;
import com.feed_the_beast.mods.ftbguilibrary.utils.Bits;
import com.feed_the_beast.mods.ftbguilibrary.utils.ClientUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class Quest
extends QuestObject
implements Movable {
    public Chapter chapter;
    public String subtitle;
    public double x;
    public double y;
    public Tristate hide;
    public String shape;
    public final List<String> description;
    public final List<QuestObject> dependencies;
    public final List<Task> tasks;
    public final List<Reward> rewards;
    public DependencyRequirement dependencyRequirement;
    public String guidePage;
    public Tristate hideDependencyLines;
    public int minRequiredDependencies;
    public Tristate hideTextUntilComplete;
    public Tristate disableJEI;
    public double size;
    public boolean optional;
    public int minWidth;
    private IFormattableTextComponent cachedDescription = null;
    private IFormattableTextComponent[] cachedText = null;

    public Quest(Chapter c) {
        this.chapter = c;
        this.subtitle = "";
        this.x = 0.0;
        this.y = 0.0;
        this.shape = "";
        this.description = new ArrayList<String>(0);
        this.dependencies = new ArrayList<QuestObject>(0);
        this.tasks = new ArrayList<Task>(1);
        this.rewards = new ArrayList<Reward>(1);
        this.guidePage = "";
        this.hideDependencyLines = Tristate.DEFAULT;
        this.hide = Tristate.DEFAULT;
        this.dependencyRequirement = DependencyRequirement.ALL_COMPLETED;
        this.minRequiredDependencies = 0;
        this.hideTextUntilComplete = Tristate.DEFAULT;
        this.disableJEI = Tristate.DEFAULT;
        this.size = 1.0;
        this.optional = false;
        this.minWidth = 0;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.QUEST;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.chapter.file;
    }

    @Override
    public Chapter getQuestChapter() {
        return this.chapter;
    }

    @Override
    public int getParentID() {
        return this.chapter.id;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74780_a("x", this.x);
        nbt.func_74780_a("y", this.y);
        if (!this.shape.isEmpty()) {
            nbt.func_74778_a("shape", this.shape);
        }
        if (!this.subtitle.isEmpty()) {
            nbt.func_74778_a("subtitle", this.subtitle);
        }
        if (!this.description.isEmpty()) {
            ListNBT array = new ListNBT();
            for (String value : this.description) {
                array.add((Object)StringNBT.func_229705_a_((String)value));
            }
            nbt.func_218657_a("description", (INBT)array);
        }
        if (!this.guidePage.isEmpty()) {
            nbt.func_74778_a("guide_page", this.guidePage);
        }
        if (this.hideDependencyLines != Tristate.DEFAULT) {
            nbt.func_74757_a("hide_dependency_lines", this.hideDependencyLines.isTrue());
        }
        if (this.minRequiredDependencies > 0) {
            nbt.func_74768_a("min_required_dependencies", (int)((byte)this.minRequiredDependencies));
        }
        this.removeInvalidDependencies();
        if (!this.dependencies.isEmpty()) {
            int[] ai = new int[this.dependencies.size()];
            int i = 0;
            for (QuestObject dep : this.dependencies) {
                ai[i] = dep.id;
                ++i;
            }
            nbt.func_74783_a("dependencies", ai);
        }
        if (this.hide != Tristate.DEFAULT) {
            nbt.func_74757_a("hide", this.hide.isTrue());
        }
        if (this.dependencyRequirement != DependencyRequirement.ALL_COMPLETED) {
            nbt.func_74778_a("dependency_requirement", this.dependencyRequirement.id);
        }
        if (this.hideTextUntilComplete != Tristate.DEFAULT) {
            nbt.func_74757_a("hide_text_until_complete", this.hideTextUntilComplete.isTrue());
        }
        if (this.size != 1.0) {
            nbt.func_74780_a("size", this.size);
        }
        if (this.optional) {
            nbt.func_74757_a("optional", true);
        }
        if (this.minWidth > 0) {
            nbt.func_74768_a("min_width", this.minWidth);
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.subtitle = nbt.func_74779_i("subtitle");
        this.x = nbt.func_74769_h("x");
        this.y = nbt.func_74769_h("y");
        this.shape = nbt.func_74779_i("shape");
        if (this.shape.equals("default")) {
            this.shape = "";
        }
        this.description.clear();
        ListNBT list = nbt.func_150295_c("description", 8);
        for (int k = 0; k < list.size(); ++k) {
            this.description.add(list.func_150307_f(k));
        }
        this.guidePage = nbt.func_74779_i("guide_page");
        this.hideDependencyLines = Tristate.read((CompoundNBT)nbt, (String)"hide_dependency_lines");
        this.minRequiredDependencies = nbt.func_74762_e("min_required_dependencies");
        this.dependencies.clear();
        for (int i : nbt.func_74759_k("dependencies")) {
            QuestObject object = this.chapter.file.get(i);
            if (object == null) continue;
            this.dependencies.add(object);
        }
        this.hide = Tristate.read((CompoundNBT)nbt, (String)"hide");
        this.dependencyRequirement = (DependencyRequirement)((Object)DependencyRequirement.NAME_MAP.get(nbt.func_74779_i("dependency_requirement")));
        this.hideTextUntilComplete = Tristate.read((CompoundNBT)nbt, (String)"hide_text_until_complete");
        this.size = nbt.func_74764_b("size") ? nbt.func_74769_h("size") : 1.0;
        this.optional = nbt.func_74767_n("optional");
        this.minWidth = nbt.func_74762_e("min_width");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (!this.subtitle.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (!this.description.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (this.size != 1.0 ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (!this.guidePage.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)256, (boolean)this.optional);
        flags = Bits.setFlag((int)flags, (int)512, (this.minWidth > 0 ? 1 : 0) != 0);
        buffer.func_150787_b(flags);
        this.hide.write(buffer);
        this.hideDependencyLines.write(buffer);
        this.hideTextUntilComplete.write(buffer);
        if (!this.subtitle.isEmpty()) {
            buffer.func_180714_a(this.subtitle);
        }
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.func_211400_a(this.shape, Short.MAX_VALUE);
        if (!this.description.isEmpty()) {
            NetUtils.writeStrings(buffer, this.description);
        }
        if (!this.guidePage.isEmpty()) {
            buffer.func_180714_a(this.guidePage);
        }
        buffer.func_150787_b(this.minRequiredDependencies);
        DependencyRequirement.NAME_MAP.write(buffer, (Object)this.dependencyRequirement);
        buffer.func_150787_b(this.dependencies.size());
        for (QuestObject d : this.dependencies) {
            if (d.invalid) {
                buffer.writeInt(0);
                continue;
            }
            buffer.writeInt(d.id);
        }
        if (this.size != 1.0) {
            buffer.writeDouble(this.size);
        }
        if (this.minWidth > 0) {
            buffer.func_150787_b(this.minWidth);
        }
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        int flags = buffer.func_150792_a();
        this.hide = Tristate.read((PacketBuffer)buffer);
        this.hideDependencyLines = Tristate.read((PacketBuffer)buffer);
        this.hideTextUntilComplete = Tristate.read((PacketBuffer)buffer);
        this.subtitle = Bits.getFlag((int)flags, (int)1) ? buffer.func_218666_n() : "";
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.shape = buffer.func_150789_c(Short.MAX_VALUE);
        if (Bits.getFlag((int)flags, (int)2)) {
            NetUtils.readStrings(buffer, this.description);
        } else {
            this.description.clear();
        }
        this.guidePage = Bits.getFlag((int)flags, (int)8) ? buffer.func_218666_n() : "";
        this.optional = Bits.getFlag((int)flags, (int)256);
        this.minRequiredDependencies = buffer.func_150792_a();
        this.dependencyRequirement = (DependencyRequirement)((Object)DependencyRequirement.NAME_MAP.read(buffer));
        this.dependencies.clear();
        int d = buffer.func_150792_a();
        for (int i = 0; i < d; ++i) {
            QuestObject object = this.chapter.file.get(buffer.readInt());
            if (object == null) continue;
            this.dependencies.add(object);
        }
        this.size = Bits.getFlag((int)flags, (int)4) ? buffer.readDouble() : 1.0;
        this.minWidth = Bits.getFlag((int)flags, (int)512) ? buffer.func_150792_a() : 0;
    }

    @Override
    public int getRelativeProgressFromChildren(PlayerData data) {
        if (this.tasks.isEmpty()) {
            return data.areDependenciesComplete(this) ? 100 : 0;
        }
        int progress = 0;
        for (Task task : this.tasks) {
            progress += data.getRelativeProgress(task);
        }
        if (progress > 0 && !data.areDependenciesComplete(this)) {
            return 0;
        }
        return Quest.getRelativeProgressFromChildren(progress, this.tasks.size());
    }

    @Override
    public void onCompleted(PlayerData data, List<ServerPlayerEntity> onlineMembers, List<ServerPlayerEntity> notifiedPlayers) {
        super.onCompleted(data, onlineMembers, notifiedPlayers);
        if (!this.disableToast) {
            for (ServerPlayerEntity player : notifiedPlayers) {
                new MessageDisplayCompletionToast(this.id).sendTo(player);
            }
        }
        data.checkAutoCompletion(this);
        MinecraftForge.EVENT_BUS.post((Event)new ObjectCompletedEvent.QuestEvent(data, this, onlineMembers, notifiedPlayers));
        for (Chapter chapter : this.chapter.file.chapters) {
            for (Quest quest : chapter.quests) {
                if (!quest.dependencies.contains(this)) continue;
                data.checkAutoCompletion(quest);
            }
        }
        if (data.isComplete(this.chapter)) {
            this.chapter.onCompleted(data, onlineMembers, notifiedPlayers);
        }
    }

    @Override
    public void changeProgress(PlayerData data, ChangeProgress type) {
        if (type.dependencies) {
            for (QuestObject dependency : this.dependencies) {
                if (dependency.invalid) continue;
                dependency.changeProgress(data, type);
            }
        }
        for (Task task : this.tasks) {
            task.changeProgress(data, type);
        }
        if (type.reset) {
            for (Reward r : this.rewards) {
                data.setRewardClaimed(r.id, false);
            }
        }
    }

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (Task task : this.tasks) {
            list.add(task.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public IFormattableTextComponent getAltTitle() {
        if (!this.tasks.isEmpty()) {
            return this.tasks.get(0).getTitle();
        }
        return new TranslationTextComponent("ftbquests.unnamed");
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.chapter.quests.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (Task task : this.tasks) {
            task.deleteChildren();
            task.invalid = true;
        }
        for (Reward reward : this.rewards) {
            reward.deleteChildren();
            reward.invalid = true;
        }
        this.tasks.clear();
        this.rewards.clear();
    }

    @Override
    public void onCreated() {
        this.chapter.quests.add(this);
        if (!this.tasks.isEmpty()) {
            ArrayList<Task> l = new ArrayList<Task>(this.tasks);
            this.tasks.clear();
            for (Task task : l) {
                task.onCreated();
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("subtitle", this.subtitle, v -> {
            this.subtitle = v;
        }, "");
        config.addList("description", this.description, (ConfigValue)new ConfigString(), (Object)"");
        config.addEnum("shape", (Object)(this.shape.isEmpty() ? "default" : this.shape), v -> {
            this.shape = v.equals("default") ? "" : v;
        }, QuestShape.idMapWithDefault);
        config.addTristate("hide", this.hide, v -> {
            this.hide = v;
        });
        config.addDouble("size", this.size, v -> {
            this.size = v;
        }, 1.0, 0.0625, 8.0);
        config.addDouble("x", this.x, v -> {
            this.x = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("y", this.y, v -> {
            this.y = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        Predicate<QuestObjectBase> depTypes = object -> object != this.chapter.file && object != this.chapter && object instanceof QuestObject;
        config.addList("dependencies", this.dependencies, new ConfigQuestObject(depTypes), null).setNameKey("ftbquests.dependencies");
        config.addEnum("dependency_requirement", (Object)this.dependencyRequirement, v -> {
            this.dependencyRequirement = v;
        }, DependencyRequirement.NAME_MAP);
        config.addInt("min_required_dependencies", this.minRequiredDependencies, v -> {
            this.minRequiredDependencies = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addTristate("hide_dependency_lines", this.hideDependencyLines, v -> {
            this.hideDependencyLines = v;
        });
        config.addString("guide_page", this.guidePage, v -> {
            this.guidePage = v;
        }, "");
        config.addTristate("hide_text_until_complete", this.hideTextUntilComplete, v -> {
            this.hideTextUntilComplete = v;
        });
        config.addEnum("disable_jei", (Object)this.disableJEI, v -> {
            this.disableJEI = v;
        }, Tristate.NAME_MAP);
        config.addBool("optional", this.optional, v -> {
            this.optional = v;
        }, false);
        config.addInt("min_width", this.minWidth, v -> {
            this.minWidth = v;
        }, 0, 0, 3000);
    }

    @Override
    public Chapter getChapter() {
        return this.chapter;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.size;
    }

    @Override
    public double getHeight() {
        return this.size;
    }

    @Override
    public String getShape() {
        return this.shape.isEmpty() ? this.chapter.getDefaultQuestShape() : this.shape;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void move(Chapter to, double x, double y) {
        new MessageMoveQuest(this.id, to.id, x, y).sendToServer();
    }

    @Override
    public boolean isVisible(PlayerData data) {
        if (this.dependencies.isEmpty()) {
            return true;
        }
        if (this.hide.get(false)) {
            return data.areDependenciesComplete(this);
        }
        for (QuestObject object : this.dependencies) {
            if (!object.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    public Task getTask(int index) {
        if (this.tasks.isEmpty()) {
            throw new IllegalStateException("Quest has no tasks!");
        }
        if (index <= 0) {
            return this.tasks.get(0);
        }
        if (index >= this.tasks.size()) {
            return this.tasks.get(this.tasks.size() - 1);
        }
        return this.tasks.get(index);
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.cachedDescription = null;
        this.cachedText = null;
        for (Task task : this.tasks) {
            task.clearCachedData();
        }
        for (Reward reward : this.rewards) {
            reward.clearCachedData();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getSubtitle() {
        if (this.cachedDescription != null) {
            return this.cachedDescription;
        }
        IFormattableTextComponent textDesc = this.loadText().getComponent("description");
        if (textDesc != StringTextComponent.field_240750_d_) {
            this.cachedDescription = textDesc;
            return this.cachedDescription;
        }
        String key = String.format("quests.%08x.description", this.id);
        IFormattableTextComponent t = FTBQuestsClient.addI18nAndColors(I18n.func_135052_a((String)key, (Object[])new Object[0]));
        this.cachedDescription = t == StringTextComponent.field_240750_d_ || key.equals(t.getString()) ? FTBQuestsClient.addI18nAndColors(this.subtitle) : t;
        return this.cachedDescription;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent[] getDescription() {
        if (this.cachedText != null) {
            return this.cachedText;
        }
        this.cachedText = this.loadText().getComponentArray("text");
        if (this.cachedText.length > 0) {
            return this.cachedText;
        }
        if (this.description.isEmpty()) {
            return new IFormattableTextComponent[0];
        }
        this.cachedText = new IFormattableTextComponent[this.description.size()];
        for (int i = 0; i < this.cachedText.length; ++i) {
            this.cachedText[i] = FTBQuestsClient.addI18nAndColors(this.description.get(i));
        }
        return this.cachedText;
    }

    public boolean hasDependency(QuestObject object) {
        if (object.invalid) {
            return false;
        }
        for (QuestObject dependency : this.dependencies) {
            if (dependency != object) continue;
            return true;
        }
        return false;
    }

    private void removeInvalidDependencies() {
        if (!this.dependencies.isEmpty()) {
            this.dependencies.removeIf(o -> o == null || o.invalid || o == this);
        }
    }

    public boolean verifyDependencies(boolean autofix) {
        try {
            if (this.verifyDependenciesInternal(this, true)) {
                return true;
            }
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        if (autofix) {
            FTBQuests.LOGGER.error("Looping dependencies found in " + this + "! Deleting all dependencies...");
            this.dependencies.clear();
            if (this.chapter.file.getSide().isServer()) {
                ServerQuestFile.INSTANCE.save();
            }
        } else {
            FTBQuests.LOGGER.error("Looping dependencies found in " + this + "!");
        }
        return false;
    }

    @Override
    public boolean verifyDependenciesInternal(QuestObject original, boolean firstLoop) {
        if (this == original && !firstLoop) {
            return false;
        }
        this.removeInvalidDependencies();
        for (QuestObject dependency : this.dependencies) {
            if (dependency.verifyDependenciesInternal(original, false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        GuiQuests gui = (GuiQuests)((Object)ClientUtils.getCurrentGuiAs(GuiQuests.class));
        if (gui != null) {
            gui.questPanel.refreshWidgets();
            gui.viewQuestPanel.refreshWidgets();
        }
    }

    public void moved(double nx, double ny, int nc) {
        QuestFile f;
        Chapter c;
        this.x = nx;
        this.y = ny;
        if (nc != this.chapter.id && (c = (f = this.getQuestFile()).getChapter(nc)) != null) {
            this.chapter.quests.remove(this);
            c.quests.add(this);
            this.chapter = c;
        }
    }

    public boolean isProgressionIgnored() {
        return this.optional;
    }

    public List<QuestObject> getDependants() {
        ArrayList<QuestObject> list = new ArrayList<QuestObject>();
        for (Chapter c : this.chapter.file.chapters) {
            for (Quest q : c.quests) {
                if (!q.dependencies.contains(this)) continue;
                list.add(q);
            }
        }
        return list;
    }
}

