/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class QuestObject
extends QuestObjectBase {
    public boolean disableToast = false;

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        if (this.disableToast) {
            nbt.func_74757_a("disable_toast", true);
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.disableToast = nbt.func_74767_n("disable_toast");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.writeBoolean(this.disableToast);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.disableToast = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addBool("disable_toast", this.disableToast, v -> {
            this.disableToast = v;
        }, false).setNameKey("ftbquests.disable_completion_toast").setCanEdit(this.getQuestChapter() == null || !this.getQuestChapter().alwaysInvisible).setOrder(10);
    }

    @Override
    public abstract void changeProgress(PlayerData var1, ChangeProgress var2);

    public abstract int getRelativeProgressFromChildren(PlayerData var1);

    public boolean cacheProgress() {
        return true;
    }

    public static int getRelativeProgressFromChildren(int progressSum, int count) {
        if (count <= 0 || progressSum <= 0) {
            return 0;
        }
        if (progressSum >= count * 100) {
            return 100;
        }
        return Math.max(1, (int)((double)progressSum / (double)count));
    }

    public boolean isVisible(PlayerData data) {
        return true;
    }

    public void onCompleted(PlayerData data, List<ServerPlayerEntity> onlineMembers, List<ServerPlayerEntity> notifiedPlayers) {
    }

    @Override
    public abstract IFormattableTextComponent getAltTitle();

    protected boolean verifyDependenciesInternal(QuestObject original, boolean firstLoop) {
        return true;
    }
}

