/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.client.FTBQuestsClient;
import com.feed_the_beast.ftbquests.net.MessageChangeProgressResponse;
import com.feed_the_beast.ftbquests.net.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.ftbquests.util.FileUtils;
import com.feed_the_beast.ftbquests.util.NBTUtils;
import com.feed_the_beast.ftbquests.util.NetUtils;
import com.feed_the_beast.ftbquests.util.QuestObjectText;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigItemStack;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigString;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigValue;
import com.feed_the_beast.mods.ftbguilibrary.config.Tristate;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfig;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.ItemIcon;
import com.feed_the_beast.mods.ftbguilibrary.utils.Bits;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLPaths;

public abstract class QuestObjectBase {
    private static final Pattern TAG_PATTERN = Pattern.compile("^[a-z0-9_]*$");
    public int id = 0;
    public boolean invalid = false;
    public String title = "";
    public ItemStack icon = ItemStack.field_190927_a;
    private List<String> tags = new ArrayList<String>(0);
    private Icon cachedIcon = null;
    private IFormattableTextComponent cachedTitle = null;
    private QuestObjectText cachedTextFile = null;
    private Set<String> cachedTags = null;

    public static boolean isNull(@Nullable QuestObjectBase object) {
        return object == null || object.invalid;
    }

    public static int getID(@Nullable QuestObjectBase object) {
        return QuestObjectBase.isNull(object) ? 0 : object.id;
    }

    public static String getCodeString(int id) {
        return Integer.toUnsignedString(id);
    }

    public static String getCodeString(@Nullable QuestObjectBase object) {
        return QuestObjectBase.getCodeString(QuestObjectBase.getID(object));
    }

    public final String getCodeString() {
        return QuestObjectBase.getCodeString(this.id);
    }

    public final String toString() {
        return this.getCodeString();
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return this.id;
    }

    public abstract QuestObjectType getObjectType();

    public abstract QuestFile getQuestFile();

    public Set<String> getTags() {
        if (this.tags.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.cachedTags == null) {
            this.cachedTags = new LinkedHashSet<String>(this.tags);
        }
        return this.cachedTags;
    }

    public boolean hasTag(String tag) {
        return !this.tags.isEmpty() && this.getTags().contains(tag);
    }

    public void changeProgress(PlayerData data, ChangeProgress type) {
    }

    public void forceProgress(PlayerData data, ChangeProgress type, boolean notifications) {
        ChangeProgress.sendUpdates = false;
        ChangeProgress.sendNotifications = notifications ? Tristate.TRUE : Tristate.FALSE;
        this.changeProgress(data, type);
        ChangeProgress.sendUpdates = true;
        ChangeProgress.sendNotifications = Tristate.DEFAULT;
        this.getQuestFile().clearCachedProgress();
        if (!this.getQuestFile().getSide().isClient()) {
            new MessageChangeProgressResponse(data.uuid, this.id, type, notifications).sendToAll();
        }
        data.save();
    }

    @Nullable
    public Chapter getQuestChapter() {
        return null;
    }

    public int getParentID() {
        return 1;
    }

    public void writeData(CompoundNBT nbt) {
        if (!this.title.isEmpty()) {
            nbt.func_74778_a("title", this.title);
        }
        NBTUtils.write(nbt, "icon", this.icon);
        if (!this.tags.isEmpty()) {
            ListNBT tagList = new ListNBT();
            for (String s : this.tags) {
                tagList.add((Object)StringNBT.func_229705_a_((String)s));
            }
            nbt.func_218657_a("tags", (INBT)tagList);
        }
    }

    public void readData(CompoundNBT nbt) {
        this.title = nbt.func_74779_i("title");
        this.icon = NBTUtils.read(nbt, "icon");
        ListNBT tagsList = nbt.func_150295_c("tags", 8);
        this.tags = new ArrayList<String>(tagsList.size());
        for (int i = 0; i < tagsList.size(); ++i) {
            this.tags.add(tagsList.func_150307_f(i));
        }
        if (nbt.func_74764_b("custom_id")) {
            this.tags.add(nbt.func_74779_i("custom_id"));
        }
    }

    public void writeNetData(PacketBuffer buffer) {
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (!this.title.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (!this.icon.func_190926_b() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (!this.tags.isEmpty() ? 1 : 0) != 0);
        buffer.func_150787_b(flags);
        if (!this.title.isEmpty()) {
            buffer.func_180714_a(this.title);
        }
        if (!this.icon.func_190926_b()) {
            buffer.func_150788_a(this.icon);
        }
        if (!this.tags.isEmpty()) {
            NetUtils.writeStrings(buffer, this.tags);
        }
    }

    public void readNetData(PacketBuffer buffer) {
        int flags = buffer.func_150792_a();
        this.title = Bits.getFlag((int)flags, (int)1) ? buffer.func_218666_n() : "";
        this.icon = Bits.getFlag((int)flags, (int)2) ? buffer.func_150791_c() : ItemStack.field_190927_a;
        this.tags = new ArrayList<String>(0);
        if (Bits.getFlag((int)flags, (int)4)) {
            NetUtils.readStrings(buffer, this.tags);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        config.addString("title", this.title, v -> {
            this.title = v;
        }, "").setNameKey("ftbquests.title").setOrder(-127);
        ((ConfigItemStack)config.add("icon", (ConfigValue)new ConfigItemStack(false, true), (Object)this.icon, v -> {
            this.icon = v;
        }, (Object)ItemStack.field_190927_a)).setNameKey("ftbquests.icon").setOrder(-126);
        config.addList("tags", this.tags, (ConfigValue)new ConfigString(TAG_PATTERN), (Object)"").setNameKey("ftbquests.tags").setOrder(-125);
    }

    @OnlyIn(value=Dist.CLIENT)
    public QuestObjectText loadText() {
        if (this.invalid || this.id == 0) {
            return QuestObjectText.NONE;
        }
        if (this.cachedTextFile == null) {
            File fileLang;
            String langCode;
            this.cachedTextFile = QuestObjectText.NONE;
            File file = FMLPaths.CONFIGDIR.get().resolve("ftbquests/quests/text/en_us/" + QuestObjectBase.getCodeString(this) + ".txt").toFile();
            HashMap<String, String[]> text = new HashMap<String, String[]>();
            if (file.exists()) {
                String currentKey = "";
                ArrayList<String> currentText = new ArrayList<String>();
                for (String s : FileUtils.readFile(file)) {
                    if (s.indexOf(91) == 0 && s.indexOf(93) == s.length() - 1) {
                        this.loadTextAdd(text, currentKey, currentText);
                        currentKey = s.substring(1, s.length() - 1);
                        continue;
                    }
                    currentText.add(s);
                }
                this.loadTextAdd(text, currentKey, currentText);
            }
            if (!(langCode = Minecraft.func_71410_x().func_135016_M().func_135041_c().getCode()).equals("en_us") && (fileLang = FMLPaths.CONFIGDIR.get().resolve("ftbquests/quests/text/" + langCode + "/" + QuestObjectBase.getCodeString(this) + ".txt").toFile()).exists()) {
                String currentKey = "";
                ArrayList<String> currentText = new ArrayList<String>();
                for (String s : FileUtils.readFile(fileLang)) {
                    if (s.indexOf(91) == 0 && s.indexOf(93) == s.length() - 1) {
                        this.loadTextAdd(text, currentKey, currentText);
                        currentKey = s.substring(1, s.length() - 1);
                        continue;
                    }
                    currentText.add(s);
                }
                this.loadTextAdd(text, currentKey, currentText);
            }
            this.cachedTextFile = text.isEmpty() ? QuestObjectText.NONE : new QuestObjectText(text);
        }
        return this.cachedTextFile;
    }

    private void loadTextAdd(Map<String, String[]> text, String currentKey, List<String> currentText) {
        while (!currentText.isEmpty() && currentText.get(0).isEmpty()) {
            currentText.remove(0);
        }
        while (!currentText.isEmpty() && currentText.get(currentText.size() - 1).isEmpty()) {
            currentText.remove(currentText.size() - 1);
        }
        if (!currentText.isEmpty()) {
            text.put(currentKey, currentText.toArray(new String[0]));
            currentText.clear();
        }
    }

    public abstract Icon getAltIcon();

    public abstract IFormattableTextComponent getAltTitle();

    public final Icon getIcon() {
        if (this.cachedIcon != null) {
            return this.cachedIcon;
        }
        if (!this.icon.func_190926_b()) {
            this.cachedIcon = ItemIcon.getItemIcon((ItemStack)this.icon);
        }
        if (this.cachedIcon == null || this.cachedIcon.isEmpty()) {
            this.cachedIcon = (Icon)ThemeProperties.ICON.get(this);
        }
        if (this.cachedIcon.isEmpty()) {
            this.cachedIcon = this.getAltIcon();
        }
        return this.cachedIcon;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final IFormattableTextComponent getTitle() {
        if (this.cachedTitle != null) {
            return this.cachedTitle.func_230532_e_();
        }
        String textTitle = this.loadText().getString("title");
        if (!textTitle.isEmpty()) {
            this.cachedTitle = new StringTextComponent(textTitle);
            return this.cachedTitle.func_230532_e_();
        }
        String key = String.format("quests.%08x.title", this.id);
        IFormattableTextComponent t = FTBQuestsClient.addI18nAndColors(I18n.func_135052_a((String)key, (Object[])new Object[0]));
        this.cachedTitle = t == StringTextComponent.field_240750_d_ || key.equals(I18n.func_135052_a((String)key, (Object[])new Object[0])) ? (!this.title.isEmpty() ? FTBQuestsClient.addI18nAndColors(this.title) : this.getAltTitle()) : t;
        return this.cachedTitle.func_230532_e_();
    }

    public final String getUnformattedTitle() {
        return this.getTitle().getString();
    }

    public void deleteSelf() {
        this.getQuestFile().remove(this.id);
    }

    public void deleteChildren() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        ClientQuestFile.INSTANCE.refreshGui();
    }

    public void onCreated() {
    }

    @Nullable
    public String getPath() {
        return null;
    }

    public void clearCachedData() {
        this.cachedIcon = null;
        this.cachedTitle = null;
        this.cachedTextFile = null;
        this.cachedTags = null;
    }

    public ConfigGroup createSubGroup(ConfigGroup group) {
        return group.getGroup(this.getObjectType().id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onEditButtonClicked(Runnable gui) {
        ConfigGroup group = new ConfigGroup("ftbquests");
        this.getConfig(this.createSubGroup(group));
        group.savedCallback = accepted -> {
            gui.run();
            if (accepted) {
                new MessageEditObject(this).sendToServer();
            }
        };
        new GuiEditConfig(group).openGui();
    }

    public int refreshJEI() {
        return 0;
    }
}

