/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.MessageCreatePlayerData;
import com.feed_the_beast.ftbquests.net.MessageDeleteObjectResponse;
import com.feed_the_beast.ftbquests.net.MessageSyncQuests;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.util.FTBQuestsInventoryListener;
import com.feed_the_beast.ftbquests.util.FileUtils;
import com.feed_the_beast.ftbquests.util.NBTUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.loading.FMLPaths;

public class ServerQuestFile
extends QuestFile {
    public static final FolderName FTBQUESTS_DATA = new FolderName("ftbquests");
    public static ServerQuestFile INSTANCE;
    public final MinecraftServer server;
    private boolean shouldSave;
    private boolean isLoading;
    private Path folder;

    public ServerQuestFile(MinecraftServer s) {
        this.server = s;
        this.shouldSave = false;
        this.isLoading = false;
    }

    public void load() {
        this.folder = FMLPaths.CONFIGDIR.get().resolve("ftbquests/quests");
        if (Files.exists(this.folder, new LinkOption[0])) {
            FTBQuests.LOGGER.info("Loading quests from " + this.folder);
            this.isLoading = true;
            this.readDataFull(this.folder);
            this.isLoading = false;
        }
        int c = this.chapters.size();
        int q = 0;
        int t = 0;
        int r = 0;
        for (Chapter chapter : this.chapters) {
            q += chapter.quests.size();
            for (Quest quest : chapter.quests) {
                t += quest.tasks.size();
                r += quest.rewards.size();
            }
        }
        FTBQuests.LOGGER.info(String.format("Loaded %d chapters, %d quests, %d tasks and %d rewards. In total, %d objects", c, q, t, r, this.getAllObjects().size()));
        Path path = this.server.func_240776_a_(FTBQUESTS_DATA);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.list(path).forEach(path1 -> {
                    CompoundNBT nbt = NBTUtils.readSNBT(path1);
                    try {
                        UUID uuid = UUID.fromString(nbt.func_74779_i("uuid"));
                        PlayerData data = new PlayerData(this, uuid);
                        this.addData(data, true);
                        data.deserializeNBT(nbt);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public boolean isLoading() {
        return this.isLoading;
    }

    @Override
    public Path getFolder() {
        return this.folder;
    }

    @Override
    public void deleteObject(int id) {
        QuestObjectBase object = this.getBase(id);
        if (object != null) {
            String file = object.getPath();
            object.deleteChildren();
            object.deleteSelf();
            this.refreshIDMap();
            this.save();
            if (file != null) {
                FileUtils.delete(this.getFolder().resolve(file).toFile());
            }
        }
        new MessageDeleteObjectResponse(id).sendToAll();
    }

    @Override
    public void save() {
        this.shouldSave = true;
    }

    public void saveNow() {
        if (this.shouldSave) {
            this.writeDataFull(this.getFolder());
            this.shouldSave = false;
        }
        Path path = this.server.func_240776_a_(FTBQUESTS_DATA);
        for (PlayerData data : this.getAllData()) {
            if (!data.shouldSave) continue;
            NBTUtils.writeSNBT(path.resolve(data.uuid.toString() + ".snbt"), data.serializeNBT());
            data.shouldSave = false;
        }
    }

    public void unload() {
        this.saveNow();
        this.deleteChildren();
        this.deleteSelf();
    }

    public void onLoggedIn(ServerPlayerEntity player) {
        UUID id = player.func_110124_au();
        PlayerData data = (PlayerData)this.playerDataMap.get(id);
        if (data == null) {
            data = new PlayerData(this, id);
            data.save();
        }
        if (!data.name.equals(player.func_146103_bH().getName())) {
            data.name = player.func_146103_bH().getName();
            data.save();
        }
        this.addData(data, false);
        for (ServerPlayerEntity player1 : this.server.func_184103_al().func_181057_v()) {
            if (player1 == player) continue;
            new MessageCreatePlayerData(data).sendTo(player1);
        }
        new MessageSyncQuests(id, this).sendTo(player);
        player.field_71069_bz.func_75132_a((IContainerListener)new FTBQuestsInventoryListener(player));
        for (Chapter chapter : ServerQuestFile.INSTANCE.chapters) {
            for (Quest quest : chapter.quests) {
                data.checkAutoCompletion(quest);
            }
        }
    }

    @Override
    public boolean updateChapterIndices() {
        if (super.updateChapterIndices()) {
            this.save();
            return true;
        }
        return false;
    }
}

