/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.loot;

import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.loot.EntityWeight;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;

public final class LootCrate {
    public final RewardTable table;
    public String stringID;
    public String itemName;
    public Color4I color;
    public boolean glow;
    public EntityWeight drops;

    public LootCrate(RewardTable t) {
        this.table = t;
        this.stringID = t.toString();
        this.itemName = "";
        this.color = Color4I.WHITE;
        this.glow = false;
        this.drops = new EntityWeight();
    }

    public void writeData(CompoundNBT nbt) {
        nbt.func_74778_a("string_id", this.stringID);
        if (!this.itemName.isEmpty()) {
            nbt.func_74778_a("item_name", this.itemName);
        }
        nbt.func_74768_a("color", this.color.rgb());
        if (this.glow) {
            nbt.func_74757_a("glow", true);
        }
        CompoundNBT nbt1 = new CompoundNBT();
        this.drops.writeData(nbt1);
        nbt.func_218657_a("drops", (INBT)nbt1);
    }

    public void readData(CompoundNBT nbt) {
        this.stringID = nbt.func_74779_i("string_id");
        this.itemName = nbt.func_74779_i("item_name");
        this.color = Color4I.rgb((int)nbt.func_74762_e("color"));
        this.glow = nbt.func_74767_n("glow");
        this.drops.readData(nbt.func_74775_l("drops"));
    }

    public void writeNetData(PacketBuffer data) {
        data.func_180714_a(this.stringID);
        data.func_180714_a(this.itemName);
        data.writeInt(this.color.rgb());
        data.writeBoolean(this.glow);
        this.drops.writeNetData(data);
    }

    public void readNetData(PacketBuffer data) {
        this.stringID = data.func_218666_n();
        this.itemName = data.func_218666_n();
        this.color = Color4I.rgb((int)data.readInt());
        this.glow = data.readBoolean();
        this.drops.readNetData(data);
    }

    public void getConfig(ConfigGroup config) {
        config.addString("id", this.stringID, v -> {
            this.stringID = v;
        }, "", Pattern.compile("[a-z0-9_]+"));
        config.addString("item_name", this.itemName, v -> {
            this.itemName = v;
        }, "");
        config.addString("color", this.color.toString(), v -> {
            this.color = Color4I.fromString((String)v);
        }, "#FFFFFF", Pattern.compile("^#[a-fA-F0-9]{6}$"));
        config.addBool("glow", this.glow, v -> {
            this.glow = v;
        }, true);
        ConfigGroup d = config.getGroup("drops");
        d.setNameKey("ftbquests.loot.entitydrops");
        d.addInt("passive", this.drops.passive, v -> {
            this.drops.passive = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.passive");
        d.addInt("monster", this.drops.monster, v -> {
            this.drops.monster = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.monster");
        d.addInt("boss", this.drops.boss, v -> {
            this.drops.boss = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.boss");
    }

    public String getStringID() {
        return this.stringID.isEmpty() ? QuestObjectBase.getCodeString(this.table) : this.stringID;
    }

    public ItemStack createStack() {
        ItemStack stack = new ItemStack((IItemProvider)FTBQuestsItems.LOOTCRATE);
        stack.func_77983_a("type", (INBT)StringNBT.func_229705_a_((String)this.getStringID()));
        return stack;
    }
}

