/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CommandReward
extends Reward {
    public String command = "/say Hi, @team!";
    public boolean playerCommand;

    public CommandReward(Quest quest) {
        super(quest);
    }

    @Override
    public RewardType getType() {
        return FTBQuestsRewards.COMMAND;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("command", this.command);
        nbt.func_74757_a("player_command", this.playerCommand);
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.command = nbt.func_74779_i("command");
        this.playerCommand = nbt.func_74767_n("player_command");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_180714_a(this.command);
        buffer.writeBoolean(this.playerCommand);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.command = buffer.func_218666_n();
        this.playerCommand = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("command", this.command, v -> {
            this.command = v;
        }, "/say Hi, @team!").setNameKey("ftbquests.reward.ftbquests.command");
        config.addBool("player", this.playerCommand, v -> {
            this.playerCommand = v;
        }, false);
    }

    @Override
    public void claim(ServerPlayerEntity player, boolean notify) {
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        overrides.put("p", player.func_146103_bH().getName());
        BlockPos pos = player.func_233580_cy_();
        overrides.put("x", pos.func_177958_n());
        overrides.put("y", pos.func_177956_o());
        overrides.put("z", pos.func_177952_p());
        Chapter chapter = this.getQuestChapter();
        if (chapter != null) {
            overrides.put("chapter", chapter);
        }
        overrides.put("quest", this.quest);
        String s = this.command;
        for (Map.Entry entry : overrides.entrySet()) {
            if (entry.getValue() == null) continue;
            s = s.replace("@" + (String)entry.getKey(), entry.getValue().toString());
        }
        player.field_71133_b.func_195571_aL().func_197059_a(this.playerCommand ? player.func_195051_bN() : player.field_71133_b.func_195573_aM(), s);
    }

    @Override
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("ftbquests.reward.ftbquests.command").func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent(this.command).func_240699_a_(TextFormatting.RED));
    }
}

