/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RandomReward
extends Reward {
    public RewardTable table = null;

    public RandomReward(Quest parent) {
        super(parent);
    }

    @Override
    public RewardType getType() {
        return FTBQuestsRewards.RANDOM;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        if (this.getTable() != null) {
            nbt.func_74768_a("table", this.getQuestFile().rewardTables.indexOf(this.getTable()));
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        int index = nbt.func_74764_b("table") ? nbt.func_74762_e("table") : -1;
        QuestFile file = this.getQuestFile();
        if (index >= 0 && index < file.rewardTables.size()) {
            this.table = file.rewardTables.get(index);
        } else {
            this.table = new RewardTable(file);
            ListNBT list = nbt.func_150295_c("rewards", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT nbt1 = list.func_150305_b(i);
                Reward reward = RewardType.createReward(this.table.fakeQuest, nbt1.func_74779_i("type"));
                if (reward == null) continue;
                reward.readData(nbt1);
                this.table.rewards.add(new WeightedReward(reward, nbt1.func_74762_e("weight")));
            }
            this.table.id = file.newID();
            if (file.getSide().isClient()) {
                this.table.title = this.getUnformattedTitle() + " " + this.toString();
            }
            file.rewardTables.add(this.table);
        }
    }

    @Nullable
    public RewardTable getTable() {
        if (this.table != null && this.table.invalid) {
            this.table = null;
        }
        return this.table;
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.writeInt(this.getTable() == null ? 0 : this.getTable().id);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.table = this.getQuestFile().getRewardTable(buffer.readInt());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        ((ConfigQuestObject)config.add("table", new ConfigQuestObject(QuestObjectType.REWARD_TABLE), (Object)this.table, v -> {
            this.table = v;
        }, (Object)this.getTable())).setNameKey("ftbquests.reward_table");
    }

    @Override
    public void claim(ServerPlayerEntity player, boolean notify) {
        if (this.getTable() == null) {
            return;
        }
        int totalWeight = this.getTable().getTotalWeight(false);
        if (totalWeight <= 0) {
            return;
        }
        int number = player.field_70170_p.field_73012_v.nextInt(totalWeight) + 1;
        int currentWeight = 0;
        for (WeightedReward reward : this.getTable().rewards) {
            if ((currentWeight += reward.weight) < number) continue;
            reward.reward.claim(player, notify);
            return;
        }
    }

    @Override
    public Icon getAltIcon() {
        return this.getTable() == null ? super.getAltIcon() : this.getTable().getIcon();
    }

    @Override
    public IFormattableTextComponent getAltTitle() {
        return this.getTable() == null ? super.getAltTitle() : (this.getTable().useTitle ? this.getTable().getTitle() : super.getAltTitle());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list) {
        if (this.getTable() != null) {
            this.getTable().addMouseOverText(list, true, false);
        }
    }

    @Override
    public boolean getExcludeFromClaimAll() {
        return false;
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.getTable() != null && this.getTable().lootCrate != null ? this.getTable().lootCrate.createStack() : null;
    }

    @Override
    public boolean automatedClaimPre(TileEntity tileEntity, List<ItemStack> items, Random random, UUID playerId, @Nullable ServerPlayerEntity player) {
        return false;
    }

    @Override
    public void automatedClaimPost(TileEntity tileEntity, UUID playerId, @Nullable ServerPlayerEntity player) {
    }
}

