/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftbquests.gui.quests.GuiQuests;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageClaimReward;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.reward.RewardAutoClaim;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.Tristate;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.ClientUtils;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Reward
extends QuestObjectBase {
    public Quest quest;
    public Tristate team;
    public RewardAutoClaim autoclaim;

    public Reward(Quest q) {
        this.quest = q;
        this.team = Tristate.DEFAULT;
        this.autoclaim = RewardAutoClaim.DEFAULT;
    }

    @Override
    public final QuestObjectType getObjectType() {
        return QuestObjectType.REWARD;
    }

    @Override
    public final QuestFile getQuestFile() {
        return this.quest.chapter.file;
    }

    @Override
    @Nullable
    public final Chapter getQuestChapter() {
        return this.quest.chapter;
    }

    @Override
    public final int getParentID() {
        return this.quest.id;
    }

    public abstract RewardType getType();

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        if (this.team != Tristate.DEFAULT) {
            this.team.write(nbt, "team_reward");
        }
        if (this.autoclaim != RewardAutoClaim.DEFAULT) {
            nbt.func_74778_a("auto", this.autoclaim.id);
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.team = Tristate.read((CompoundNBT)nbt, (String)"team_reward");
        this.autoclaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP.get(nbt.func_74779_i("auto")));
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        Tristate.NAME_MAP.write(buffer, (Object)this.team);
        RewardAutoClaim.NAME_MAP.write(buffer, (Object)this.autoclaim);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.team = (Tristate)Tristate.NAME_MAP.read(buffer);
        this.autoclaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP.read(buffer));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("team", (Object)this.team, v -> {
            this.team = v;
        }, Tristate.NAME_MAP).setNameKey("ftbquests.reward.team_reward");
        config.addEnum("autoclaim", (Object)this.autoclaim, v -> {
            this.autoclaim = v;
        }, RewardAutoClaim.NAME_MAP).setNameKey("ftbquests.reward.autoclaim");
    }

    public abstract void claim(ServerPlayerEntity var1, boolean var2);

    public Optional<ItemStack> claimAutomated(TileEntity tileEntity, UUID playerId, @Nullable ServerPlayerEntity player, boolean simulate) {
        if (player != null) {
            if (!simulate) {
                this.claim(player, false);
            }
            return Optional.of(ItemStack.field_190927_a);
        }
        return Optional.empty();
    }

    public boolean automatedClaimPre(TileEntity tileEntity, List<ItemStack> items, Random random, UUID playerId, @Nullable ServerPlayerEntity player) {
        return player != null;
    }

    public void automatedClaimPost(TileEntity tileEntity, UUID playerId, @Nullable ServerPlayerEntity player) {
        if (player != null) {
            this.claim(player, false);
        }
    }

    @Override
    public final void deleteSelf() {
        this.quest.rewards.remove(this);
        for (PlayerData data : this.getQuestFile().getAllData()) {
            data.setRewardClaimed(this.id, false);
        }
        super.deleteSelf();
    }

    @Override
    public final void deleteChildren() {
        for (PlayerData data : this.getQuestFile().getAllData()) {
            data.setRewardClaimed(this.id, false);
        }
        super.deleteChildren();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        GuiQuests gui = (GuiQuests)((Object)ClientUtils.getCurrentGuiAs(GuiQuests.class));
        if (gui != null && gui.getViewedQuest() != null) {
            gui.viewQuestPanel.refreshWidgets();
        }
        if (gui != null) {
            gui.questPanel.refreshWidgets();
        }
    }

    @Override
    public void onCreated() {
        this.quest.rewards.add(this);
    }

    public final boolean isTeamReward() {
        return this.team.get(this.quest.chapter.file.defaultRewardTeam);
    }

    public final RewardAutoClaim getAutoClaimType() {
        if (this.quest.chapter.alwaysInvisible && (this.autoclaim == RewardAutoClaim.DEFAULT || this.autoclaim == RewardAutoClaim.DISABLED)) {
            return RewardAutoClaim.ENABLED;
        }
        if (this.autoclaim == RewardAutoClaim.DEFAULT) {
            return this.quest.chapter.file.defaultRewardAutoClaim;
        }
        return this.autoclaim;
    }

    @Override
    public final void changeProgress(PlayerData data, ChangeProgress type) {
        if (type == ChangeProgress.RESET || type == ChangeProgress.RESET_DEPS) {
            data.setRewardClaimed(this.id, false);
        }
    }

    @Override
    public Icon getAltIcon() {
        return this.getType().getIcon();
    }

    @Override
    public IFormattableTextComponent getAltTitle() {
        return this.getType().getDisplayName();
    }

    @Override
    public final ConfigGroup createSubGroup(ConfigGroup group) {
        RewardType type = this.getType();
        return group.getGroup(this.getObjectType().id).getGroup(type.getRegistryName().func_110624_b()).getGroup(type.getRegistryName().func_110623_a());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list) {
    }

    public boolean addTitleInMouseOverText() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        if (canClick) {
            button.playClickSound();
            new MessageClaimReward(this.id, true).sendToServer();
        }
    }

    public boolean getExcludeFromClaimAll() {
        return this.getType().getExcludeFromListRewards();
    }

    @Nullable
    public Object getIngredient() {
        return this.getIcon().getIngredient();
    }

    @Override
    public final int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }

    public String getButtonText() {
        return "";
    }
}

