/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftbquests.gui.GuiSelectQuestObject;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.reward.RandomReward;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfig;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public final class RewardType
extends ForgeRegistryEntry<RewardType> {
    private static ForgeRegistry<RewardType> REGISTRY;
    public final Provider provider;
    private IFormattableTextComponent displayName;
    private Icon icon;
    private GuiProvider guiProvider;
    private boolean excludeFromListRewards;

    public static void createRegistry() {
        if (REGISTRY == null) {
            ResourceLocation registryName = new ResourceLocation("ftbquests", "rewards");
            REGISTRY = (ForgeRegistry)new RegistryBuilder().setType(RewardType.class).setName(registryName).create();
            MinecraftForge.EVENT_BUS.post((Event)new RegistryEvent.Register(registryName, REGISTRY));
        }
    }

    public static ForgeRegistry<RewardType> getRegistry() {
        return REGISTRY;
    }

    @Nullable
    public static Reward createReward(Quest quest, String id) {
        if (id.isEmpty()) {
            id = "ftbquests:item";
        } else if (id.indexOf(58) == -1) {
            id = "ftbquests:" + id;
        }
        RewardType type = (RewardType)REGISTRY.getValue(new ResourceLocation(id));
        if (type == null) {
            return null;
        }
        return type.provider.create(quest);
    }

    public RewardType(Provider p) {
        this.provider = p;
        this.displayName = null;
        this.icon = GuiIcons.MONEY_BAG;
        this.guiProvider = new GuiProvider(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void openCreationGui(Runnable gui, Quest quest, Consumer<Reward> callback) {
                Reward reward = RewardType.this.provider.create(quest);
                if (reward instanceof RandomReward) {
                    ConfigQuestObject config = new ConfigQuestObject(QuestObjectType.REWARD_TABLE);
                    new GuiSelectQuestObject(config, accepted -> {
                        if (accepted) {
                            ((RandomReward)reward).table = (RewardTable)config.value;
                            callback.accept(reward);
                        }
                        gui.run();
                    }).openGui();
                    return;
                }
                ConfigGroup group = new ConfigGroup("ftbquests");
                reward.getConfig(reward.createSubGroup(group));
                group.savedCallback = accepted -> {
                    if (accepted) {
                        callback.accept(reward);
                    }
                    gui.run();
                };
                new GuiEditConfig(group).openGui();
            }
        };
    }

    public String getTypeForNBT() {
        return this.getRegistryName().func_110624_b().equals("ftbquests") ? this.getRegistryName().func_110623_a() : this.getRegistryName().toString();
    }

    public RewardType setDisplayName(IFormattableTextComponent name) {
        this.displayName = name;
        return this;
    }

    public IFormattableTextComponent getDisplayName() {
        if (this.displayName == null) {
            ResourceLocation id = this.getRegistryName();
            this.displayName = id == null ? new StringTextComponent("error") : new TranslationTextComponent("ftbquests.reward." + id.func_110624_b() + '.' + id.func_110623_a());
        }
        return this.displayName;
    }

    public RewardType setIcon(Icon i) {
        this.icon = i;
        return this;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public RewardType setGuiProvider(GuiProvider p) {
        this.guiProvider = p;
        return this;
    }

    public GuiProvider getGuiProvider() {
        return this.guiProvider;
    }

    public RewardType setExcludeFromListRewards(boolean v) {
        this.excludeFromListRewards = v;
        return this;
    }

    public boolean getExcludeFromListRewards() {
        return this.excludeFromListRewards;
    }

    public static interface GuiProvider {
        @OnlyIn(value=Dist.CLIENT)
        public void openCreationGui(Runnable var1, Quest var2, Consumer<Reward> var3);
    }

    @FunctionalInterface
    public static interface Provider {
        public Reward create(Quest var1);
    }
}

