/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftbquests.net.MessageDisplayRewardToast;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class XPLevelsReward
extends Reward {
    public int xpLevels;

    public XPLevelsReward(Quest quest, int x) {
        super(quest);
        this.xpLevels = x;
    }

    public XPLevelsReward(Quest quest) {
        this(quest, 5);
    }

    @Override
    public RewardType getType() {
        return FTBQuestsRewards.XP_LEVELS;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74768_a("xp_levels", this.xpLevels);
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.xpLevels = nbt.func_74762_e("xp_levels");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_150787_b(this.xpLevels);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.xpLevels = buffer.func_150792_a();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("xp_levels", this.xpLevels, v -> {
            this.xpLevels = v;
        }, 1, 1, Integer.MAX_VALUE).setNameKey("ftbquests.reward.ftbquests.xp_levels");
    }

    @Override
    public void claim(ServerPlayerEntity player, boolean notify) {
        player.func_82242_a(this.xpLevels);
        if (notify) {
            new MessageDisplayRewardToast(this.id, (ITextComponent)new TranslationTextComponent("ftbquests.reward.ftbquests.xp_levels").func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent("+" + this.xpLevels).func_240699_a_(TextFormatting.GREEN)), (Icon)Icon.EMPTY).sendTo(player);
        }
    }

    @Override
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("ftbquests.reward.ftbquests.xp_levels").func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent("+" + this.xpLevels).func_240699_a_(TextFormatting.GREEN));
    }

    @Override
    public String getButtonText() {
        return "+" + this.xpLevels;
    }
}

