/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigFluid;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigNBT;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigValue;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidTask
extends Task {
    public static final ResourceLocation TANK_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/tank.png");
    public Fluid fluid = Fluids.field_204546_a;
    public CompoundNBT fluidNBT = null;
    public long amount = 1000L;
    private FluidStack cachedFluidStack = null;

    public FluidTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.FLUID;
    }

    @Override
    public long getMaxProgress() {
        return this.amount;
    }

    @Override
    public String getMaxProgressString() {
        return FluidTask.getVolumeString(this.amount);
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("fluid", this.fluid.getRegistryName().toString());
        nbt.func_74772_a("amount", this.amount);
        if (this.fluidNBT != null) {
            nbt.func_218657_a("nbt", (INBT)this.fluidNBT);
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.func_74779_i("fluid")));
        if (this.fluid == null || this.fluid == Fluids.field_204541_a) {
            this.fluid = Fluids.field_204546_a;
        }
        this.amount = Math.max(1L, nbt.func_74763_f("amount"));
        this.fluidNBT = (CompoundNBT)nbt.func_74781_a("nbt");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_192572_a(this.fluid.getRegistryName());
        buffer.func_150786_a(this.fluidNBT);
        buffer.func_179254_b(this.amount);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(buffer.func_192575_l());
        if (this.fluid == null || this.fluid == Fluids.field_204541_a) {
            this.fluid = Fluids.field_204546_a;
        }
        this.fluidNBT = buffer.func_150793_b();
        this.amount = buffer.func_179260_f();
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.cachedFluidStack = null;
    }

    public FluidStack createFluidStack() {
        if (this.cachedFluidStack == null) {
            this.cachedFluidStack = new FluidStack(this.fluid, 1000, this.fluidNBT);
        }
        return this.cachedFluidStack;
    }

    public static String getVolumeString(long a) {
        StringBuilder builder = new StringBuilder();
        if (a >= 1000L) {
            if (a % 1000L != 0L) {
                builder.append((double)a / 1000.0);
            } else {
                builder.append(a / 1000L);
            }
        } else {
            builder.append(a % 1000L);
        }
        builder.append(' ');
        if (a < 1000L) {
            builder.append('m');
        }
        builder.append('B');
        return builder.toString();
    }

    @Override
    public Icon getAltIcon() {
        FluidStack stack = this.createFluidStack();
        FluidAttributes a = stack.getFluid().getAttributes();
        return Icon.getIcon((String)a.getStillTexture(stack).toString()).withTint(Color4I.rgb((int)a.getColor(stack))).combineWith(Icon.getIcon((String)TANK_TEXTURE.toString()));
    }

    @Override
    public IFormattableTextComponent getAltTitle() {
        return new StringTextComponent(FluidTask.getVolumeString(this.amount) + " of ").func_230529_a_(this.createFluidStack().getDisplayName());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.add("fluid", (ConfigValue)new ConfigFluid(false), (Object)this.fluid, v -> {
            this.fluid = v;
        }, (Object)Fluids.field_204546_a);
        config.add("fluid_nbt", (ConfigValue)new ConfigNBT(), (Object)this.fluidNBT, v -> {
            this.fluidNBT = v;
        }, null);
        config.addLong("amount", this.amount, v -> {
            this.amount = v;
        }, 1000L, 1L, Long.MAX_VALUE);
    }

    @Override
    public boolean canInsertItem() {
        return true;
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.createFluidStack();
    }

    @Override
    public TaskData createData(PlayerData data) {
        return new Data(this, data);
    }

    public static class Data
    extends TaskData<FluidTask> {
        private Data(FluidTask t, PlayerData data) {
            super(t, data);
        }

        @Override
        public String getProgressString() {
            return FluidTask.getVolumeString((int)this.progress);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int add;
            if (resource.getAmount() > 0 && !this.isComplete() && ((FluidTask)this.task).createFluidStack().isFluidEqual(resource) && this.data.canStartTasks(((FluidTask)this.task).quest) && (add = (int)Math.min((long)resource.getAmount(), Math.min(Integer.MAX_VALUE, ((FluidTask)this.task).amount - this.progress))) > 0) {
                if (action.execute() && this.data.file.getSide().isServer()) {
                    this.addProgress(add);
                }
                return add;
            }
            return 0;
        }
    }
}

