/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.EnergyTask;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.mods.ftbguilibrary.utils.StringUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ForgeEnergyTask
extends EnergyTask {
    public static final ResourceLocation EMPTY_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/fe_empty.png");
    public static final ResourceLocation FULL_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/fe_full.png");

    public ForgeEnergyTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.FORGE_ENERGY;
    }

    @Override
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("ftbquests.task.ftbquests.forge_energy.text", new Object[]{StringUtils.formatDouble((double)this.value, (boolean)true)});
    }

    @Override
    public TaskData createData(PlayerData data) {
        return new Data(this, data);
    }

    public static class Data
    extends TaskData<ForgeEnergyTask> {
        private Data(ForgeEnergyTask task, PlayerData data) {
            super(task, data);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (maxReceive > 0 && !this.isComplete()) {
                long add = Math.min((long)maxReceive, ((ForgeEnergyTask)this.task).value - this.progress);
                if (((ForgeEnergyTask)this.task).maxInput > 0L) {
                    add = Math.min(add, ((ForgeEnergyTask)this.task).maxInput);
                }
                if (add > 0L) {
                    if (!simulate) {
                        this.addProgress(add);
                    }
                    return (int)add;
                }
            }
            return 0;
        }
    }
}

