/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.NameMap;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.ItemIcon;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import java.util.ArrayList;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class KillTask
extends Task {
    public static final ResourceLocation ZOMBIE = new ResourceLocation("minecraft:zombie");
    public ResourceLocation entity = ZOMBIE;
    public long value = 100L;

    public KillTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.KILL;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("entity", this.entity.toString());
        nbt.func_74772_a("value", this.value);
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.entity = new ResourceLocation(nbt.func_74779_i("entity"));
        this.value = nbt.func_74763_f("value");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_180714_a(this.entity.toString());
        buffer.func_179254_b(this.value);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.entity = new ResourceLocation(buffer.func_218666_n());
        this.value = buffer.func_150792_a();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        for (EntityType type : ForgeRegistries.ENTITIES) {
            ids.add(type.getRegistryName());
        }
        config.addEnum("entity", (Object)this.entity, v -> {
            this.entity = v;
        }, NameMap.of((Object)ZOMBIE, ids).nameKey(v -> "entity." + v.func_110624_b() + "." + v.func_110623_a()).icon(v -> {
            SpawnEggItem item = SpawnEggItem.func_200889_b((EntityType)((EntityType)ForgeRegistries.ENTITIES.getValue(v)));
            return ItemIcon.getItemIcon((Item)(item != null ? item : Items.field_221671_bX));
        }).create(), (Object)ZOMBIE);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 100L, 1L, Long.MAX_VALUE);
    }

    @Override
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("ftbquests.task.ftbquests.kill.title", new Object[]{this.getMaxProgressString(), new TranslationTextComponent("entity." + this.entity.func_110624_b() + "." + this.entity.func_110623_a())});
    }

    @Override
    public Icon getAltIcon() {
        SpawnEggItem item = SpawnEggItem.func_200889_b((EntityType)((EntityType)ForgeRegistries.ENTITIES.getValue(this.entity)));
        return ItemIcon.getItemIcon((Item)(item != null ? item : Items.field_221671_bX));
    }

    @Override
    public TaskData createData(PlayerData data) {
        return new Data(this, data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    public static class Data
    extends TaskData<KillTask> {
        private Data(KillTask task, PlayerData data) {
            super(task, data);
        }

        public void kill(LivingEntity entity) {
            if (!this.isComplete() && ((KillTask)this.task).entity.equals((Object)entity.func_200600_R().getRegistryName())) {
                this.addProgress(1L);
            }
        }
    }
}

