/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.BooleanTaskData;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LocationTask
extends Task {
    public RegistryKey<World> dimension = World.field_234918_g_;
    public boolean ignoreDimension = false;
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public int w = 1;
    public int h = 1;
    public int d = 1;

    public LocationTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.LOCATION;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("dimension", this.dimension.func_240901_a_().toString());
        nbt.func_74757_a("ignore_dimension", this.ignoreDimension);
        nbt.func_74783_a("position", new int[]{this.x, this.y, this.z});
        nbt.func_74783_a("size", new int[]{this.w, this.h, this.d});
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("dimension")));
        this.ignoreDimension = nbt.func_74767_n("ignore_dimension");
        int[] pos = nbt.func_74759_k("position");
        if (pos.length == 3) {
            this.x = pos[0];
            this.y = pos[1];
            this.z = pos[2];
        }
        int[] size = nbt.func_74759_k("size");
        if (pos.length == 3) {
            this.w = size[0];
            this.h = size[1];
            this.d = size[2];
        }
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_192572_a(this.dimension.func_240901_a_());
        buffer.writeBoolean(this.ignoreDimension);
        buffer.func_150787_b(this.x);
        buffer.func_150787_b(this.y);
        buffer.func_150787_b(this.z);
        buffer.func_150787_b(this.w);
        buffer.func_150787_b(this.h);
        buffer.func_150787_b(this.d);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buffer.func_192575_l());
        this.ignoreDimension = buffer.readBoolean();
        this.x = buffer.func_150792_a();
        this.y = buffer.func_150792_a();
        this.z = buffer.func_150792_a();
        this.w = buffer.func_150792_a();
        this.h = buffer.func_150792_a();
        this.d = buffer.func_150792_a();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("dim", this.dimension.func_240901_a_().toString(), v -> {
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(v));
        }, "minecraft:overworld");
        config.addBool("ignore_dim", this.ignoreDimension, v -> {
            this.ignoreDimension = v;
        }, false);
        config.addInt("x", this.x, v -> {
            this.x = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("y", this.y, v -> {
            this.y = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("z", this.z, v -> {
            this.z = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("w", this.w, v -> {
            this.w = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addInt("h", this.h, v -> {
            this.h = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addInt("d", this.d, v -> {
            this.d = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 3;
    }

    @Override
    public TaskData createData(PlayerData data) {
        return new Data(this, data);
    }

    public static class Data
    extends BooleanTaskData<LocationTask> {
        private Data(LocationTask task, PlayerData data) {
            super(task, data);
        }

        @Override
        public String getProgressString() {
            return this.progress > 0L ? "1" : "0";
        }

        @Override
        public boolean canSubmit(ServerPlayerEntity player) {
            int x;
            int y;
            if ((((LocationTask)this.task).ignoreDimension || ((LocationTask)this.task).dimension == player.field_70170_p.func_234923_W_()) && (y = MathHelper.func_76128_c((double)player.func_226277_ct_())) >= ((LocationTask)this.task).y && y < ((LocationTask)this.task).y + ((LocationTask)this.task).h && (x = MathHelper.func_76128_c((double)player.func_226277_ct_())) >= ((LocationTask)this.task).x && x < ((LocationTask)this.task).x + ((LocationTask)this.task).w) {
                int z = MathHelper.func_76128_c((double)player.func_226281_cx_());
                return z >= ((LocationTask)this.task).z && z < ((LocationTask)this.task).z + ((LocationTask)this.task).d;
            }
            return false;
        }
    }
}

