/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.NameMap;
import java.util.ArrayList;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StatTask
extends Task {
    public ResourceLocation stat = Stats.field_188070_B;
    public int value = 1;

    public StatTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.STAT;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public String getMaxProgressString() {
        return Integer.toString(this.value);
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("stat", this.stat.toString());
        nbt.func_74768_a("value", this.value);
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.stat = new ResourceLocation(nbt.func_74779_i("stat"));
        this.value = nbt.func_74762_e("value");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_192572_a(this.stat);
        buffer.func_150787_b(this.value);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.stat = buffer.func_192575_l();
        this.value = buffer.func_150792_a();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        ArrayList list = new ArrayList();
        Stats.field_199092_j.iterator().forEachRemaining(s -> list.add(s.func_197920_b()));
        config.addEnum("stat", (Object)this.stat, v -> {
            this.stat = v;
        }, NameMap.of((Object)Stats.field_188070_B, list).name(v -> new TranslationTextComponent("stat." + v.func_110624_b() + "." + v.func_110623_a())).create());
        config.addInt("value", this.value, v -> {
            this.value = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    @Override
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("stat." + this.stat.func_110624_b() + "." + this.stat.func_110623_a());
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 3;
    }

    @Override
    public TaskData createData(PlayerData data) {
        return new Data(this, data);
    }

    public static class Data
    extends TaskData<StatTask> {
        private Data(StatTask task, PlayerData data) {
            super(task, data);
        }

        @Override
        public String getProgressString() {
            return Integer.toString((int)this.progress);
        }

        @Override
        public void submitTask(ServerPlayerEntity player, ItemStack item) {
            if (this.isComplete()) {
                return;
            }
            int set = Math.min(((StatTask)this.task).value, player.func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)((StatTask)this.task).stat)));
            if ((long)set > this.progress) {
                this.setProgress(set);
            }
        }
    }
}

