/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftbquests.events.CustomTaskEvent;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.gui.quests.GuiQuests;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.net.MessageSubmitTask;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.task.CustomTask;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.ClientUtils;
import com.feed_the_beast.mods.ftbguilibrary.utils.StringUtils;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.WrappedIngredient;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class Task
extends QuestObject {
    public final Quest quest;

    public Task(Quest q) {
        this.quest = q;
    }

    @Override
    public final QuestObjectType getObjectType() {
        return QuestObjectType.TASK;
    }

    @Override
    public final QuestFile getQuestFile() {
        return this.quest.chapter.file;
    }

    @Override
    public final Chapter getQuestChapter() {
        return this.quest.chapter;
    }

    @Override
    public final int getParentID() {
        return this.quest.id;
    }

    public abstract TaskType getType();

    public abstract TaskData createData(PlayerData var1);

    @Override
    public final int getRelativeProgressFromChildren(PlayerData data) {
        return data.getTaskData(this).getRelativeProgress();
    }

    @Override
    public final void onCompleted(PlayerData data, List<ServerPlayerEntity> onlineMembers, List<ServerPlayerEntity> notifiedPlayers) {
        super.onCompleted(data, onlineMembers, notifiedPlayers);
        MinecraftForge.EVENT_BUS.post((Event)new ObjectCompletedEvent.TaskEvent(data, this, onlineMembers, notifiedPlayers));
        boolean questComplete = data.isComplete(this.quest);
        if (this.quest.tasks.size() > 1 && !questComplete && !this.disableToast) {
            new MessageDisplayCompletionToast(this.id).sendTo(notifiedPlayers);
        }
        if (questComplete) {
            this.quest.onCompleted(data, onlineMembers, notifiedPlayers);
        }
    }

    public long getMaxProgress() {
        return 1L;
    }

    public String getMaxProgressString() {
        return StringUtils.formatDouble((double)this.getMaxProgress(), (boolean)true);
    }

    @Override
    public final void changeProgress(PlayerData data, ChangeProgress type) {
        data.getTaskData(this).setProgress(type.reset ? 0L : this.getMaxProgress());
    }

    @Override
    public final void deleteSelf() {
        this.quest.tasks.remove(this);
        for (PlayerData data : this.quest.chapter.file.getAllData()) {
            data.removeTaskData(this);
        }
        super.deleteSelf();
    }

    @Override
    public final void deleteChildren() {
        for (PlayerData data : this.quest.chapter.file.getAllData()) {
            data.removeTaskData(this);
        }
        super.deleteChildren();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        GuiQuests gui = (GuiQuests)((Object)ClientUtils.getCurrentGuiAs(GuiQuests.class));
        if (gui != null) {
            gui.questPanel.refreshWidgets();
            gui.viewQuestPanel.refreshWidgets();
        }
    }

    @Override
    public final void onCreated() {
        this.quest.tasks.add(this);
        for (PlayerData data : this.quest.chapter.file.getAllData()) {
            data.createTaskData(this, true);
        }
        if (this instanceof CustomTask) {
            MinecraftForge.EVENT_BUS.post((Event)new CustomTaskEvent((CustomTask)this));
        }
    }

    @Override
    public Icon getAltIcon() {
        return this.getType().getIcon();
    }

    @Override
    public IFormattableTextComponent getAltTitle() {
        return this.getType().getDisplayName();
    }

    @Override
    public final ConfigGroup createSubGroup(ConfigGroup group) {
        TaskType type = this.getType();
        return group.getGroup(this.getObjectType().id).getGroup(type.getRegistryName().func_110624_b()).getGroup(type.getRegistryName().func_110623_a());
    }

    public void drawGUI(@Nullable TaskData data, MatrixStack matrixStack, int x, int y, int w, int h) {
        this.getIcon().draw(matrixStack, x, y, w, h);
    }

    public boolean canInsertItem() {
        return false;
    }

    public boolean consumesResources() {
        return this.canInsertItem();
    }

    public boolean hideProgressNumbers() {
        return this.getMaxProgress() <= 1L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list, @Nullable TaskData data) {
        if (this.consumesResources()) {
            list.blankLine();
            list.add((ITextComponent)new TranslationTextComponent("ftbquests.task.click_to_submit").func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.UNDERLINE}));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addTitleInMouseOverText() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        if (canClick && this.autoSubmitOnPlayerTick() <= 0) {
            button.playClickSound();
            new MessageSubmitTask(this.id).sendToServer();
        }
    }

    public boolean submitItemsOnInventoryChange() {
        return false;
    }

    @Nullable
    public Object getIngredient() {
        if (this.addTitleInMouseOverText()) {
            return this.getIcon().getIngredient();
        }
        return new WrappedIngredient(this.getIcon().getIngredient()).tooltip();
    }

    @Override
    public final int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getButtonText() {
        return this.getMaxProgress() > 1L || this.consumesResources() ? new StringTextComponent(this.getMaxProgressString()) : (IFormattableTextComponent)StringTextComponent.field_240750_d_;
    }

    public int autoSubmitOnPlayerTick() {
        return 0;
    }

    @Override
    public final boolean cacheProgress() {
        return false;
    }
}

