/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftbquests.events.TaskStartedEvent;
import com.feed_the_beast.ftbquests.net.MessageUpdateTaskProgress;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.util.FTBQuestsInventoryListener;
import com.feed_the_beast.mods.ftbguilibrary.utils.StringUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TaskData<T extends Task> {
    public final T task;
    public final PlayerData data;
    public long progress = 0L;
    private boolean taskCompleted = false;

    public TaskData(T q, PlayerData d) {
        this.task = q;
        this.data = d;
    }

    public final void readProgress(long p) {
        long max = ((Task)this.task).getMaxProgress();
        this.progress = Math.max(0L, Math.min(p, max));
        this.taskCompleted = this.progress == max;
    }

    public final void setProgress(long p) {
        if (this.progress != (p = Math.max(0L, Math.min(p, ((Task)this.task).getMaxProgress())))) {
            this.progress = p;
            this.taskCompleted = false;
            ((Task)this.task).quest.chapter.file.clearCachedProgress();
            if (this.data.file.getSide().isServer()) {
                if (ChangeProgress.sendUpdates) {
                    new MessageUpdateTaskProgress(this.data, ((Task)this.task).id, this.progress).sendToAll();
                }
                if (p == 0L) {
                    MinecraftForge.EVENT_BUS.post((Event)new TaskStartedEvent(this));
                }
                if (!this.taskCompleted && this.isComplete()) {
                    this.taskCompleted = true;
                    List<ServerPlayerEntity> onlineMembers = this.data.getOnlineMembers();
                    List<Object> notifiedPlayers = !((Task)this.task).quest.chapter.alwaysInvisible && ChangeProgress.sendNotifications.get(ChangeProgress.sendUpdates) ? onlineMembers : Collections.emptyList();
                    ((Task)this.task).onCompleted(this.data, onlineMembers, notifiedPlayers);
                    for (ServerPlayerEntity player : onlineMembers) {
                        FTBQuestsInventoryListener.detect(player, ItemStack.field_190927_a, ((Task)this.task).id);
                    }
                }
            }
            this.data.save();
        }
    }

    public final void addProgress(long p) {
        this.setProgress(this.progress + p);
    }

    public final int getRelativeProgress() {
        long max = ((Task)this.task).getMaxProgress();
        if (max <= 0L) {
            return 0;
        }
        if (this.progress <= 0L) {
            return 0;
        }
        if (this.progress >= max) {
            return 100;
        }
        return (int)Math.max(1.0, (double)this.progress * 100.0 / (double)max);
    }

    public final boolean isComplete() {
        long max = ((Task)this.task).getMaxProgress();
        return max > 0L && this.progress >= max;
    }

    public final boolean isStarted() {
        return this.progress > 0L && ((Task)this.task).getMaxProgress() > 0L;
    }

    public String getProgressString() {
        return StringUtils.formatDouble((double)this.progress, (boolean)true);
    }

    public String toString() {
        return this.data.toString() + "#" + this.task;
    }

    public void submitTask(ServerPlayerEntity player, ItemStack item) {
    }

    public final void submitTask(ServerPlayerEntity player) {
        this.submitTask(player, ItemStack.field_190927_a);
    }
}

