/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.ISingleLongValueTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigFromString;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigLong;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfig;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfigFromString;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public final class TaskType
extends ForgeRegistryEntry<TaskType> {
    private static ForgeRegistry<TaskType> REGISTRY;
    public final Provider provider;
    private IFormattableTextComponent displayName;
    private Icon icon;
    private GuiProvider guiProvider;

    public static void createRegistry() {
        if (REGISTRY == null) {
            ResourceLocation registryName = new ResourceLocation("ftbquests", "tasks");
            REGISTRY = (ForgeRegistry)new RegistryBuilder().setType(TaskType.class).setName(registryName).create();
            MinecraftForge.EVENT_BUS.post((Event)new RegistryEvent.Register(registryName, REGISTRY));
        }
    }

    public static ForgeRegistry<TaskType> getRegistry() {
        return REGISTRY;
    }

    @Nullable
    public static Task createTask(Quest quest, String id) {
        if (id.isEmpty()) {
            id = "ftbquests:item";
        } else if (id.indexOf(58) == -1) {
            id = "ftbquests:" + id;
        }
        TaskType type = (TaskType)REGISTRY.getValue(new ResourceLocation(id));
        if (type == null) {
            return null;
        }
        return type.provider.create(quest);
    }

    public TaskType(Provider p) {
        this.provider = p;
        this.displayName = null;
        this.icon = GuiIcons.ACCEPT;
        this.guiProvider = new GuiProvider(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void openCreationGui(Runnable gui, Quest quest, Consumer<Task> callback) {
                Task task = TaskType.this.provider.create(quest);
                if (task instanceof ISingleLongValueTask) {
                    ISingleLongValueTask t = (ISingleLongValueTask)((Object)task);
                    ConfigLong c = new ConfigLong(0L, t.getMaxConfigValue());
                    GuiEditConfigFromString.open((ConfigFromString)c, (Object)t.getDefaultConfigValue(), (Object)t.getDefaultConfigValue(), accepted -> {
                        if (accepted) {
                            ((ISingleLongValueTask)((Object)task)).setValue((Long)c.value);
                            callback.accept(task);
                        }
                        gui.run();
                    });
                    return;
                }
                ConfigGroup group = new ConfigGroup("ftbquests");
                task.getConfig(task.createSubGroup(group));
                group.savedCallback = accepted -> {
                    if (accepted) {
                        callback.accept(task);
                    }
                    gui.run();
                };
                new GuiEditConfig(group).openGui();
            }
        };
    }

    public String getTypeForNBT() {
        return this.getRegistryName().func_110624_b().equals("ftbquests") ? this.getRegistryName().func_110623_a() : this.getRegistryName().toString();
    }

    public TaskType setDisplayName(IFormattableTextComponent name) {
        this.displayName = name;
        return this;
    }

    public IFormattableTextComponent getDisplayName() {
        if (this.displayName == null) {
            ResourceLocation id = this.getRegistryName();
            this.displayName = id == null ? new StringTextComponent("error") : new TranslationTextComponent("ftbquests.task." + id.func_110624_b() + '.' + id.func_110623_a());
        }
        return this.displayName;
    }

    public TaskType setIcon(Icon i) {
        this.icon = i;
        return this;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public TaskType setGuiProvider(GuiProvider p) {
        this.guiProvider = p;
        return this;
    }

    public GuiProvider getGuiProvider() {
        return this.guiProvider;
    }

    public static interface GuiProvider {
        @OnlyIn(value=Dist.CLIENT)
        public void openCreationGui(Runnable var1, Quest var2, Consumer<Task> var3);
    }

    @FunctionalInterface
    public static interface Provider {
        public Task create(Quest var1);
    }
}

