/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.ISingleLongValueTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class XPTask
extends Task
implements ISingleLongValueTask {
    public long value = 1L;
    public boolean points = false;

    public XPTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.XP;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public String getMaxProgressString() {
        return Long.toUnsignedString(this.points && this.value <= Integer.MAX_VALUE ? (long)XPTask.getLevelForExperience((int)this.value) : this.value);
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74772_a("value", this.value);
        nbt.func_74757_a("points", this.points);
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.value = nbt.func_74763_f("value");
        this.points = nbt.func_74767_n("points");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_179254_b(this.value);
        buffer.writeBoolean(this.points);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.value = buffer.func_179260_f();
        this.points = buffer.readBoolean();
    }

    @Override
    public void setValue(long v) {
        this.value = v;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 1L, 1L, Long.MAX_VALUE);
        config.addBool("points", this.points, v -> {
            this.points = v;
        }, false);
    }

    @Override
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("ftbquests.reward.ftbquests.xp_levels").func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent(this.getMaxProgressString()).func_240699_a_(TextFormatting.RED));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    public TaskData createData(PlayerData data) {
        return new Data(this, data);
    }

    public static int getPlayerXP(PlayerEntity player) {
        return (int)((float)XPTask.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(PlayerEntity player, int amount) {
        int experience;
        player.field_71067_cb = experience = XPTask.getPlayerXP(player) + amount;
        player.field_71068_ca = XPTask.getLevelForExperience(experience);
        int expForLevel = XPTask.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return XPTask.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + XPTask.sum(level - 15, 37, 5);
        }
        return 1395 + XPTask.sum(level - 30, 112, 9);
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = XPTask.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static class Data
    extends TaskData<XPTask> {
        private Data(XPTask task, PlayerData data) {
            super(task, data);
        }

        @Override
        public String getProgressString() {
            return Long.toUnsignedString(((XPTask)this.task).points && ((XPTask)this.task).value <= Integer.MAX_VALUE ? (long)XPTask.getLevelForExperience((int)this.progress) : this.progress);
        }

        @Override
        public void submitTask(ServerPlayerEntity player, ItemStack item) {
            int add = (int)Math.min(((XPTask)this.task).points ? (long)XPTask.getPlayerXP((PlayerEntity)player) : (long)player.field_71068_ca, Math.min(((XPTask)this.task).value - this.progress, Integer.MAX_VALUE));
            if (add <= 0) {
                return;
            }
            if (((XPTask)this.task).points) {
                XPTask.addPlayerXP((PlayerEntity)player, -add);
                player.func_82242_a(0);
            } else {
                player.func_82242_a(-add);
            }
            this.addProgress(add);
        }
    }
}

