/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileUtils {
    public static List<String> read(InputStream in) throws IOException {
        String line;
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((line = reader.readLine()) != null) {
            list.add(line);
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readFile(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            List<String> list = FileUtils.read(in);
            return list;
        }
        catch (IOException ex) {
            return Collections.emptyList();
        }
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    FileUtils.delete(f);
                }
            }
        } else {
            file.delete();
        }
    }
}

