/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.config;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigCallback;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigWithVariants;
import com.feed_the_beast.mods.ftbguilibrary.config.NameMap;
import com.feed_the_beast.mods.ftbguilibrary.config.Tristate;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.misc.GuiButtonListBase;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class ConfigEnum<E>
extends ConfigWithVariants<E> {
    public final NameMap<E> nameMap;

    public ConfigEnum(NameMap<E> nm) {
        this.nameMap = nm;
        this.defaultValue = this.nameMap.defaultValue;
        this.value = this.nameMap.defaultValue;
    }

    @Override
    public ITextComponent getStringForGUI(E v) {
        return this.nameMap.getDisplayName(v);
    }

    @Override
    public Color4I getColor(E v) {
        Color4I col = this.nameMap.getColor(v);
        return col.isEmpty() ? Tristate.DEFAULT.color : col;
    }

    @Override
    public void addInfo(TooltipList list) {
        super.addInfo(list);
        if (this.nameMap.size() > 0) {
            list.blankLine();
            for (E v : this.nameMap) {
                boolean e = this.isEqual(v, this.value);
                StringTextComponent c = new StringTextComponent(e ? "+ " : "- ");
                c.func_240699_a_(e ? TextFormatting.AQUA : TextFormatting.DARK_GRAY);
                c.func_230529_a_(this.nameMap.getDisplayName(v));
                list.add((ITextComponent)c);
            }
        }
    }

    @Override
    public void onClicked(MouseButton button, final ConfigCallback callback) {
        if (this.nameMap.values.size() > 16 || GuiBase.isCtrlKeyDown()) {
            GuiButtonListBase g = new GuiButtonListBase(){

                @Override
                public void addButtons(Panel panel) {
                    for (final Object v : ConfigEnum.this.nameMap) {
                        panel.add(new SimpleTextButton(panel, ConfigEnum.this.nameMap.getDisplayName(v), Icon.EMPTY){

                            @Override
                            public void onClicked(MouseButton button) {
                                this.playClickSound();
                                ConfigEnum.this.setCurrentValue(v);
                                callback.save(true);
                            }
                        });
                    }
                }
            };
            g.setHasSearchBox(true);
            g.openGui();
            return;
        }
        super.onClicked(button, callback);
    }

    @Override
    public E getIteration(E v, boolean next) {
        return next ? this.nameMap.getNext(v) : this.nameMap.getPrevious(v);
    }

    @Override
    public Icon getIcon(@Nullable E v) {
        Icon icon;
        if (v != null && !(icon = this.nameMap.getIcon(v)).isEmpty()) {
            return icon;
        }
        return super.getIcon(v);
    }
}

