/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.config;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigCallback;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigValue;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfigList;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ConfigList<E, CV extends ConfigValue<E>>
extends ConfigValue<List<E>> {
    public static final StringTextComponent EMPTY_LIST = new StringTextComponent("[]");
    public static final StringTextComponent NON_EMPTY_LIST = new StringTextComponent("[...]");
    public static final Color4I COLOR = Color4I.rgb(16755273);
    public final CV type;

    public ConfigList(CV t) {
        this.type = t;
    }

    @Override
    public List<E> copy(List<E> v) {
        ArrayList<E> list = new ArrayList<E>(v.size());
        for (E value : v) {
            list.add(((ConfigValue)this.type).copy(value));
        }
        return list;
    }

    @Override
    public Color4I getColor(List<E> v) {
        return COLOR;
    }

    @Override
    public void addInfo(TooltipList l) {
        if (!((List)this.value).isEmpty()) {
            l.add(ConfigList.info("List"));
            for (Object value : (List)this.value) {
                l.add(((ConfigValue)this.type).getStringForGUI(value));
            }
            if (!((List)this.defaultValue).isEmpty()) {
                l.blankLine();
            }
        }
        if (!((List)this.defaultValue).isEmpty()) {
            l.add(ConfigList.info("Default"));
            for (Object value : (List)this.defaultValue) {
                l.add(((ConfigValue)this.type).getStringForGUI(value));
            }
        }
    }

    @Override
    public void onClicked(MouseButton button, ConfigCallback callback) {
        new GuiEditConfigList(this, callback).openGui();
    }

    @Override
    public ITextComponent getStringForGUI(List<E> v) {
        return v == null ? NULL_TEXT : (v.isEmpty() ? EMPTY_LIST : NON_EMPTY_LIST);
    }
}

