/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.config;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigNumber;
import com.feed_the_beast.mods.ftbguilibrary.utils.StringUtils;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class ConfigLong
extends ConfigNumber<Long> {
    public ConfigLong(long mn, long mx) {
        super(mn, mx);
    }

    @Override
    public void addInfo(TooltipList list) {
        super.addInfo(list);
        if ((Long)this.min != Long.MIN_VALUE) {
            list.add(ConfigLong.info("Min", StringUtils.formatDouble(((Long)this.min).longValue())));
        }
        if ((Long)this.max != Long.MAX_VALUE) {
            list.add(ConfigLong.info("Max", StringUtils.formatDouble(((Long)this.max).longValue())));
        }
    }

    @Override
    public boolean parse(@Nullable Consumer<Long> callback, String string) {
        try {
            long v = Long.decode(string);
            if (v >= (Long)this.min && v <= (Long)this.max) {
                if (callback != null) {
                    callback.accept(v);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

