/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.config;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigFromString;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ConfigString
extends ConfigFromString<String> {
    public static final Color4I COLOR = Color4I.rgb(16755273);
    public final Pattern pattern;

    public ConfigString(@Nullable Pattern p) {
        this.pattern = p;
        this.defaultValue = "";
        this.value = "";
    }

    public ConfigString() {
        this(null);
    }

    @Override
    public Color4I getColor(@Nullable String v) {
        return COLOR;
    }

    @Override
    public boolean parse(@Nullable Consumer<String> callback, String string) {
        if (this.pattern == null || this.pattern.matcher(string).matches()) {
            if (callback != null) {
                callback.accept(string);
            }
            return true;
        }
        return false;
    }

    @Override
    public ITextComponent getStringForGUI(@Nullable String v) {
        return v == null ? NULL_TEXT : new StringTextComponent('\"' + v + '\"');
    }

    @Override
    public void addInfo(TooltipList list) {
        super.addInfo(list);
        if (this.pattern != null) {
            list.add(ConfigString.info("Regex", this.pattern.pattern()));
        }
    }
}

