/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.config;

import com.feed_the_beast.mods.ftbguilibrary.config.NameMap;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.eventbus.api.Event;

public enum Tristate {
    FALSE("false", "false", Event.Result.DENY, Color4I.rgb(13969460), 1, GuiIcons.ACCEPT_GRAY),
    TRUE("true", "true", Event.Result.ALLOW, Color4I.rgb(0x33AA33), 0, GuiIcons.ACCEPT),
    DEFAULT("default", "Default", Event.Result.DEFAULT, Color4I.rgb(38143), 2, GuiIcons.SETTINGS);

    public static final Tristate[] VALUES;
    public static final NameMap<Tristate> NAME_MAP;
    public final String name;
    public final String displayName;
    public final Event.Result result;
    public final Color4I color;
    private final int opposite;
    public final Icon icon;

    public static Tristate read(CompoundNBT nbt, String key) {
        return nbt.func_74764_b(key) ? (nbt.func_74767_n(key) ? TRUE : FALSE) : DEFAULT;
    }

    public static Tristate read(PacketBuffer buffer) {
        return VALUES[buffer.readUnsignedByte()];
    }

    private Tristate(String n2, String dn, Event.Result r, Color4I c, int o, Icon i) {
        this.name = n2;
        this.displayName = dn;
        this.result = r;
        this.color = c;
        this.opposite = o;
        this.icon = i;
    }

    public boolean isTrue() {
        return this == TRUE;
    }

    public boolean isFalse() {
        return this == FALSE;
    }

    public boolean isDefault() {
        return this == DEFAULT;
    }

    public boolean get(boolean def) {
        return this.isDefault() ? def : this.isTrue();
    }

    public Tristate getOpposite() {
        return NAME_MAP.get(this.opposite);
    }

    public String toString() {
        return this.name;
    }

    public void write(CompoundNBT nbt, String key) {
        if (!this.isDefault()) {
            nbt.func_74757_a(key, this.isTrue());
        }
    }

    public void write(PacketBuffer buffer) {
        buffer.writeByte(this.ordinal());
    }

    static {
        VALUES = Tristate.values();
        NAME_MAP = NameMap.of(DEFAULT, VALUES).id(v -> v.name).name(v -> new StringTextComponent(v.displayName)).color(v -> v.color).icon(v -> v.icon).create();
    }
}

