/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.config.gui;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigCallback;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigFluid;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.ItemIcon;
import com.feed_the_beast.mods.ftbguilibrary.misc.GuiButtonListBase;
import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Items;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class GuiSelectFluid
extends GuiButtonListBase {
    private final ConfigFluid config;
    private final ConfigCallback callback;

    public GuiSelectFluid(ConfigFluid c, ConfigCallback cb) {
        this.setTitle((ITextComponent)new TranslationTextComponent("ftbguilibrary.select_fluid.gui"));
        this.setHasSearchBox(true);
        this.config = c;
        this.callback = cb;
    }

    @Override
    public void addButtons(Panel panel) {
        if (this.config.allowEmpty) {
            FluidStack fluidStack = new FluidStack(Fluids.field_204541_a, 1000);
            panel.add(new SimpleTextButton(panel, fluidStack.getDisplayName(), ItemIcon.getItemIcon(Items.field_151133_ar)){

                @Override
                public void onClicked(MouseButton button) {
                    this.playClickSound();
                    GuiSelectFluid.this.config.setCurrentValue(Fluids.field_204541_a);
                    GuiSelectFluid.this.callback.save(true);
                }

                @Override
                public Object getIngredientUnderMouse() {
                    return new FluidStack(Fluids.field_204541_a, 1000);
                }
            });
        }
        for (final Fluid fluid : ForgeRegistries.FLUIDS) {
            if (fluid == Fluids.field_204541_a || fluid.func_207188_f().func_206889_d()) continue;
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            FluidAttributes attributes = fluidStack.getFluid().getAttributes();
            panel.add(new SimpleTextButton(panel, fluidStack.getDisplayName(), Icon.getIcon(attributes.getStillTexture(fluidStack)).withTint(Color4I.rgb(attributes.getColor(fluidStack)))){

                @Override
                public void onClicked(MouseButton button) {
                    this.playClickSound();
                    GuiSelectFluid.this.config.setCurrentValue(fluid);
                    GuiSelectFluid.this.callback.save(true);
                }

                @Override
                public Object getIngredientUnderMouse() {
                    return new FluidStack(fluid, 1000);
                }
            });
        }
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return false;
        }
        return false;
    }
}

