/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.icon;

import com.feed_the_beast.mods.ftbguilibrary.icon.AtlasSpriteIcon;
import com.feed_the_beast.mods.ftbguilibrary.icon.BulletIcon;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.CombinedIcon;
import com.feed_the_beast.mods.ftbguilibrary.icon.Drawable;
import com.feed_the_beast.mods.ftbguilibrary.icon.HollowRectangleIcon;
import com.feed_the_beast.mods.ftbguilibrary.icon.IconAnimation;
import com.feed_the_beast.mods.ftbguilibrary.icon.IconPresets;
import com.feed_the_beast.mods.ftbguilibrary.icon.IconProperties;
import com.feed_the_beast.mods.ftbguilibrary.icon.IconWithBorder;
import com.feed_the_beast.mods.ftbguilibrary.icon.IconWithPadding;
import com.feed_the_beast.mods.ftbguilibrary.icon.ImageIcon;
import com.feed_the_beast.mods.ftbguilibrary.icon.ItemIcon;
import com.feed_the_beast.mods.ftbguilibrary.icon.MutableColor4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.PartIcon;
import com.feed_the_beast.mods.ftbguilibrary.icon.URLImageIcon;
import com.feed_the_beast.mods.ftbguilibrary.utils.IPixelBuffer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Icon
implements Drawable {
    public static final Color4I EMPTY = new Color4I(255, 255, 255, 255){

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void draw(MatrixStack matrixStack, int x, int y, int w, int h) {
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void draw3D(MatrixStack matrixStack) {
        }

        @Override
        public MutableColor4I mutable() {
            return new MutableColor4I.None();
        }

        @Override
        @Nullable
        public IPixelBuffer createPixelBuffer() {
            return null;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }
    };

    public static Icon getIcon(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return EMPTY;
        }
        if (json.isJsonObject()) {
            JsonObject o = json.getAsJsonObject();
            if (o.has("id")) {
                switch (o.get("id").getAsString()) {
                    case "color": {
                        Color4I color = Color4I.fromJson(o.get("color"));
                        return o.has("mutable") && o.get("mutable").getAsBoolean() ? color.mutable() : color;
                    }
                    case "padding": {
                        return Icon.getIcon(o.get("parent")).withPadding(o.has("padding") ? o.get("padding").getAsInt() : 0);
                    }
                    case "tint": {
                        return Icon.getIcon(o.get("parent")).withTint(Color4I.fromJson(o.get("color")));
                    }
                    case "animation": {
                        ArrayList<Icon> icons = new ArrayList<Icon>();
                        for (JsonElement e : o.get("icons").getAsJsonArray()) {
                            icons.add(Icon.getIcon(e));
                        }
                        return IconAnimation.fromList(icons, true);
                    }
                    case "border": {
                        Icon icon = EMPTY;
                        Color4I outline = EMPTY;
                        boolean roundEdges = false;
                        if (o.has("icon")) {
                            icon = Icon.getIcon(o.get("icon"));
                        }
                        if (o.has("color")) {
                            outline = Color4I.fromJson(o.get("color"));
                        }
                        if (o.has("round_edges")) {
                            roundEdges = o.get("round_edges").getAsBoolean();
                        }
                        return icon.withBorder(outline, roundEdges);
                    }
                    case "bullet": {
                        return new BulletIcon().withColor(o.has("color") ? Color4I.fromJson(o.get("color")) : EMPTY);
                    }
                    case "part": {
                        PartIcon partIcon = new PartIcon(Icon.getIcon(o.get("parent")));
                        partIcon.posX = o.get("x").getAsInt();
                        partIcon.posY = o.get("y").getAsInt();
                        partIcon.width = o.get("width").getAsInt();
                        partIcon.height = o.get("height").getAsInt();
                        partIcon.corner = o.get("corner").getAsInt();
                        partIcon.textureWidth = o.get("texture_width").getAsInt();
                        partIcon.textureHeight = o.get("texture_height").getAsInt();
                        return partIcon;
                    }
                }
            }
        } else if (json.isJsonArray()) {
            ArrayList<Icon> list = new ArrayList<Icon>();
            for (JsonElement e : json.getAsJsonArray()) {
                list.add(Icon.getIcon(e));
            }
            return CombinedIcon.getCombined(list);
        }
        String s = json.getAsString();
        if (s.isEmpty()) {
            return EMPTY;
        }
        Icon icon = IconPresets.MAP.get(s);
        return icon == null ? Icon.getIcon(s) : icon;
    }

    public static Icon getIcon(ResourceLocation id) {
        return Icon.getIcon(id.toString());
    }

    public static Icon getIcon(String id) {
        if (id.isEmpty()) {
            return EMPTY;
        }
        String[] comb = id.split(" \\+ ");
        if (comb.length > 1) {
            ArrayList<Icon> list = new ArrayList<Icon>(comb.length);
            for (String s : comb) {
                list.add(Icon.getIcon(s));
            }
            return CombinedIcon.getCombined(list);
        }
        String[] ids = id.split("; ");
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ids[i].trim();
        }
        Icon icon = Icon.getIcon0(ids[0]);
        if (ids.length > 1 && !icon.isEmpty()) {
            Color4I tint;
            Color4I color;
            Color4I border;
            IconProperties properties = new IconProperties();
            for (int i = 1; i < ids.length; ++i) {
                String[] p = ids[i].split("=", 2);
                properties.set(p[0], p.length == 1 ? "1" : p[1]);
            }
            icon.setProperties(properties);
            int padding = properties.getInt("padding", 0);
            if (padding != 0) {
                icon = icon.withPadding(padding);
            }
            if ((border = properties.getColor("border")) != null) {
                icon = icon.withBorder(border, properties.getBoolean("border_round_edges", false));
            }
            if ((color = properties.getColor("color")) != null) {
                icon = icon.withColor(color);
            }
            if ((tint = properties.getColor("tint")) != null) {
                icon = icon.withTint(tint);
            }
        }
        return icon;
    }

    private static Icon getIcon0(String id) {
        if (id.isEmpty() || id.equals("none")) {
            return EMPTY;
        }
        Color4I col = Color4I.fromString(id);
        if (!col.isEmpty()) {
            return col;
        }
        String[] ida = id.split(":", 2);
        if (ida.length == 2) {
            switch (ida[0]) {
                case "color": {
                    return Color4I.fromString(ida[1]);
                }
                case "item": {
                    return ItemIcon.getItemIcon(ida[1]);
                }
                case "bullet": {
                    return new BulletIcon().withColor(Color4I.fromString(ida[1]));
                }
                case "http": 
                case "https": 
                case "file": {
                    try {
                        return new URLImageIcon(new URI(id));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                case "hollow_rectangle": {
                    return new HollowRectangleIcon(Color4I.fromString(ida[1]), false);
                }
                case "part": {
                    return new PartIcon(Icon.getIcon(ida[1]));
                }
            }
        }
        return id.endsWith(".png") || id.endsWith(".jpg") ? new ImageIcon(new ResourceLocation(id)) : new AtlasSpriteIcon(new ResourceLocation(id));
    }

    public boolean isEmpty() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bindTexture() {
    }

    public Icon copy() {
        return this;
    }

    public JsonElement getJson() {
        return new JsonPrimitive(this.toString());
    }

    public final Icon combineWith(Icon icon) {
        if (icon.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return icon;
        }
        return new CombinedIcon(this, icon);
    }

    public final Icon combineWith(Icon ... icons) {
        if (icons.length == 0) {
            return this;
        }
        if (icons.length == 1) {
            return this.combineWith(icons[0]);
        }
        ArrayList<Icon> list = new ArrayList<Icon>(icons.length + 1);
        list.add(this);
        list.addAll(Arrays.asList(icons));
        return CombinedIcon.getCombined(list);
    }

    public Icon withColor(Color4I color) {
        return this.copy();
    }

    public final Icon withBorder(Color4I color, boolean roundEdges) {
        if (color.isEmpty()) {
            return this.withPadding(1);
        }
        return new IconWithBorder(this, color, roundEdges);
    }

    public final Icon withPadding(int padding) {
        return padding == 0 ? this : new IconWithPadding(this, padding);
    }

    public Icon withTint(Color4I color) {
        return this;
    }

    public Icon withUV(float u0, float v0, float u1, float v1) {
        return this;
    }

    public Icon withUV(float x, float y, float w, float h, float tw, float th) {
        return this.withUV(x / tw, y / th, (x + w) / tw, (y + h) / th);
    }

    public int hashCode() {
        return this.getJson().hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Icon && this.getJson().equals(((Icon)o).getJson());
    }

    public boolean hasPixelBuffer() {
        return false;
    }

    @Nullable
    public IPixelBuffer createPixelBuffer() {
        return null;
    }

    @Nullable
    public Object getIngredient() {
        return null;
    }

    protected void setProperties(IconProperties properties) {
    }
}

