/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.icon;

import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemIcon
extends Icon {
    ItemStack stack;

    public static Icon getItemIcon(ItemStack stack) {
        return stack.func_190926_b() ? EMPTY : new ItemIcon(stack);
    }

    public static Icon getItemIcon(Item item) {
        return ItemIcon.getItemIcon(new ItemStack((IItemProvider)item));
    }

    public static Icon getItemIcon(Block block) {
        return ItemIcon.getItemIcon(new ItemStack((IItemProvider)block));
    }

    public static Icon getItemIcon(String lazyStackString) {
        return lazyStackString.isEmpty() ? EMPTY : new LazyItemIcon(lazyStackString);
    }

    private ItemIcon(ItemStack is) {
        this.stack = is;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrixStack, int x, int y, int w, int h) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 100.0);
        GuiHelper.drawItem(matrixStack, this.getStack(), x, y, (float)w / 16.0f, (float)h / 16.0f, true, null);
        matrixStack.func_227865_b_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawStatic(MatrixStack matrixStack, int x, int y, int w, int h) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 100.0);
        GuiHelper.drawItem(matrixStack, this.getStack(), x, y, (float)w / 16.0f, (float)h / 16.0f, false, null);
        matrixStack.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawItem3D(MatrixStack matrixStack, ItemStack stack) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw3D(MatrixStack matrixStack) {
        ItemIcon.drawItem3D(matrixStack, this.getStack());
    }

    public String toString() {
        ItemStack is = this.getStack();
        StringBuilder builder = new StringBuilder("item:");
        builder.append(is.func_77973_b().getRegistryName());
        int count = is.func_190916_E();
        int damage = is.func_77952_i();
        CompoundNBT nbt = is.func_77978_p();
        if (count > 1 || damage > 0 || nbt != null) {
            builder.append(' ');
            builder.append(count);
        }
        if (damage > 0 || nbt != null) {
            builder.append(' ');
            builder.append(damage);
        }
        if (nbt != null) {
            builder.append(' ');
            builder.append(nbt);
        }
        return builder.toString();
    }

    @Override
    public int hashCode() {
        ItemStack stack = this.getStack();
        int h = stack.func_77973_b().hashCode();
        h = h * 31 + stack.func_190916_E();
        h += stack.func_77952_i() * 31;
        h = h * 31 + Objects.hashCode(stack.func_77978_p());
        return h;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof ItemIcon && ItemStack.func_77989_b((ItemStack)this.getStack(), (ItemStack)((ItemIcon)o).getStack());
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.getStack();
    }

    private static class LazyItemIcon
    extends ItemIcon {
        private final String lazyStackString;
        private boolean createdStack;

        private LazyItemIcon(String s) {
            super(ItemStack.field_190927_a);
            this.lazyStackString = s;
        }

        @Override
        public ItemStack getStack() {
            if (!this.createdStack) {
                String[] s = this.lazyStackString.split(" ", 4);
                this.stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s[0])));
                if (s.length >= 2 && !s[1].equals("1")) {
                    this.stack.func_190920_e(Integer.parseInt(s[1]));
                }
                if (s.length >= 3 && !s[2].equals("0")) {
                    this.stack.func_196085_b(Integer.parseInt(s[2]));
                }
                if (s.length >= 4 && !s[3].equals("null")) {
                    try {
                        this.stack.func_77982_d(JsonToNBT.func_180713_a((String)s[3]));
                    }
                    catch (CommandSyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
                this.createdStack = true;
                if (this.stack.func_190926_b()) {
                    this.stack = new ItemStack((IItemProvider)Items.field_221803_eL);
                    this.stack.func_200302_a((ITextComponent)new StringTextComponent(this.lazyStackString));
                }
            }
            return this.stack;
        }

        @Override
        public String toString() {
            return "item:" + this.lazyStackString;
        }
    }
}

