/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.newui;

import com.feed_the_beast.mods.ftbguilibrary.newui.Widget;
import com.feed_the_beast.mods.ftbguilibrary.newui.event.MousePressedEvent;
import com.feed_the_beast.mods.ftbguilibrary.newui.event.MouseReleasedEvent;
import com.feed_the_beast.mods.ftbguilibrary.newui.event.MouseScrolledEvent;
import com.feed_the_beast.mods.ftbguilibrary.newui.event.PositionUpdateEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class Panel
extends Widget {
    public final List<Widget> widgets;
    private boolean onlyRenderWidgetsInside = true;
    private boolean onlyInteractWithWidgetsInside = true;
    private double contentWidth = Double.NaN;
    private double contentHeight = Double.NaN;
    public int contentWidthExtra = 0;
    public int contentHeightExtra = 0;

    public Panel() {
        this.type = "panel";
        this.widgets = new ArrayList<Widget>();
    }

    public Panel add(String id, Widget widget) {
        widget.id = id.isEmpty() ? widget.type + "_" + (this.widgets.size() + 1) : id;
        widget.ui = this.ui;
        widget.panel = this;
        this.widgets.add(widget);
        return this;
    }

    public void remove(Widget widget) {
        this.widgets.remove(widget);
    }

    public Panel add(Widget widget) {
        return this.add("", widget);
    }

    public Panel addPanel(String id, Consumer<Panel> callback) {
        Panel panel = new Panel();
        panel.id = id;
        callback.accept(panel);
        return this.add(panel);
    }

    public Panel addPanel(Consumer<Panel> callback) {
        return this.addPanel("", callback);
    }

    public boolean getOnlyRenderWidgetsInside() {
        return this.onlyRenderWidgetsInside;
    }

    public void setOnlyRenderWidgetsInside(boolean value) {
        this.onlyRenderWidgetsInside = value;
    }

    public boolean getOnlyInteractWithWidgetsInside() {
        return this.onlyInteractWithWidgetsInside;
    }

    public void setOnlyInteractWithWidgetsInside(boolean value) {
        this.onlyInteractWithWidgetsInside = value;
    }

    public double getContentWidth() {
        if (Double.isNaN(this.contentWidth)) {
            if (this.widgets.isEmpty()) {
                return this.contentWidthExtra;
            }
            double minX = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            for (Widget w : this.widgets) {
                if (w.rx < minX) {
                    minX = w.rx;
                }
                if (!(w.rx + w.width > maxX)) continue;
                maxX = w.rx + w.width;
            }
            this.contentWidth = maxX - minX + (double)this.contentWidthExtra;
        }
        return this.contentWidth;
    }

    public double getContentHeight() {
        if (Double.isNaN(this.contentHeight)) {
            if (this.widgets.isEmpty()) {
                return this.contentHeightExtra;
            }
            double minY = Double.POSITIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            for (Widget w : this.widgets) {
                if (w.ry < minY) {
                    minY = w.ry;
                }
                if (!(w.ry + w.height > maxY)) continue;
                maxY = w.ry + w.height;
            }
            this.contentHeight = maxY - minY + (double)this.contentHeightExtra;
        }
        return this.contentHeight;
    }

    @Override
    public void updatePosition(PositionUpdateEvent event) {
        super.updatePosition(event);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            this.widgets.get(i).updatePosition(event);
        }
    }

    @Override
    public boolean mousePressed(MousePressedEvent event) {
        if (this.getOnlyInteractWithWidgetsInside() && !this.mouseOver) {
            return false;
        }
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.mousePressed(event)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(MouseReleasedEvent event) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled()) continue;
            widget.mouseReleased(event);
        }
    }

    @Override
    public boolean mouseScrolled(MouseScrolledEvent event) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.mouseScrolled(event)) continue;
            return true;
        }
        return this.scrollPanel(event);
    }

    public boolean scrollPanel(MouseScrolledEvent event) {
        return false;
    }
}

