/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.utils;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class MathUtils {
    public static final Random RAND = new Random();
    public static final float[] NORMALS_X = new float[]{0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f};
    public static final float[] NORMALS_Y = new float[]{-1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public static final float[] NORMALS_Z = new float[]{0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f};
    public static final int[] ROTATION_X = new int[]{90, 270, 0, 0, 0, 0};
    public static final int[] ROTATION_Y = new int[]{0, 0, 180, 0, 90, 270};
    private static final int CACHED_SPIRAL_POINTS_SIZE = 81;
    private static ChunkPos[] CACHED_SPIRAL_POINTS = null;

    public static double sq(double value) {
        return value * value;
    }

    public static double sqrt(double value) {
        return value == 0.0 || value == 1.0 ? value : Math.sqrt(value);
    }

    public static double sqrt2sq(double x, double y) {
        return MathUtils.sqrt(MathUtils.sq(x) + MathUtils.sq(y));
    }

    public static double sqrt3sq(double x, double y, double z) {
        return MathUtils.sqrt(MathUtils.sq(x) + MathUtils.sq(y) + MathUtils.sq(z));
    }

    public static double distSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return x1 == x2 && y1 == y2 && z1 == z2 ? 0.0 : MathUtils.sq(x2 - x1) + MathUtils.sq(y2 - y1) + MathUtils.sq(z2 - z1);
    }

    public static double dist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return MathUtils.sqrt(MathUtils.distSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distSq(double x1, double y1, double x2, double y2) {
        return MathUtils.sq(x2 - x1) + MathUtils.sq(y2 - y1);
    }

    public static double dist(double x1, double y1, double x2, double y2) {
        return MathUtils.sqrt(MathUtils.distSq(x1, y1, x2, y2));
    }

    public static int chunk(int i) {
        return i >> 4;
    }

    public static int chunk(double d) {
        return MathUtils.chunk(MathHelper.func_76128_c((double)d));
    }

    public static boolean canParseInt(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean canParseDouble(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static float lerp(float min, float max, float value) {
        return min + (max - min) * value;
    }

    public static double lerp(double min, double max, double value) {
        return min + (max - min) * value;
    }

    public static Vector3d lerp(double x1, double y1, double z1, double x2, double y2, double z2, double value) {
        return new Vector3d(MathUtils.lerp(x1, x2, value), MathUtils.lerp(y1, y2, value), MathUtils.lerp(z1, z2, value));
    }

    public static Vector3d lerp(Vector3d v1, Vector3d v2, double value) {
        return MathUtils.lerp(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, value);
    }

    public static double map(double min1, double max1, double min2, double max2, double value) {
        return MathUtils.lerp(min2, max2, (value - min1) / (max1 - min1));
    }

    public static double mod(double i, double n) {
        return (i %= n) < 0.0 ? i + n : i;
    }

    public static int mod(int i, int n) {
        return (i %= n) < 0 ? i + n : i;
    }

    public static ChunkPos getSpiralPoint(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index < 81) {
            if (CACHED_SPIRAL_POINTS == null) {
                CACHED_SPIRAL_POINTS = new ChunkPos[81];
                for (int i = 0; i < 81; ++i) {
                    MathUtils.CACHED_SPIRAL_POINTS[i] = MathUtils.getSpiralPoint0(i);
                }
            }
            return CACHED_SPIRAL_POINTS[index];
        }
        return MathUtils.getSpiralPoint0(index);
    }

    public static ChunkPos getSpiralPoint0(int index) {
        int x = 0;
        int z = 0;
        int p = 1;
        int ringIndex = 0;
        double sqrtceil = Math.ceil(Math.sqrt(index));
        int s = (int)(sqrtceil + (sqrtceil % 2.0 + 1.0) % 2.0);
        if (s > 1) {
            ringIndex = index - (s - 2) * (s - 2);
            p = s * s - (s - 2) * (s - 2);
        }
        int ri = (ringIndex + s / 2) % p;
        if (s > 1) {
            int n = ri < p / 4 ? ri : (ri <= p / 4 * 2 - 1 ? p / 4 : (x = ri <= p / 4 * 3 ? p / 4 * 3 - ri : 0));
        }
        if (s > 1) {
            z = ri < p / 4 ? 0 : (ri <= p / 4 * 2 - 1 ? ri - p / 4 : (ri <= p / 4 * 3 ? p / 4 : p - ri));
        }
        return new ChunkPos(x - s / 2, z - s / 2);
    }
}

