/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import com.feed_the_beast.mods.ftbguilibrary.widget.WrappedIngredient;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class Button
extends Widget {
    protected ITextComponent title;
    protected Icon icon;

    public Button(Panel panel, ITextComponent t, Icon i) {
        super(panel);
        this.setSize(16, 16);
        this.icon = i;
        this.title = t;
    }

    public Button(Panel panel) {
        this(panel, StringTextComponent.field_240750_d_, Icon.EMPTY);
    }

    @Override
    public ITextComponent getTitle() {
        return this.title;
    }

    public Button setTitle(ITextComponent s) {
        this.title = s;
        return this;
    }

    public Button setIcon(Icon i) {
        this.icon = i;
        return this;
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        theme.drawButton(matrixStack, x, y, w, h, this.getWidgetType());
    }

    public void drawIcon(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        this.icon.draw(matrixStack, x, y, w, h);
    }

    @Override
    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        int s = h >= 16 ? 16 : 8;
        this.drawBackground(matrixStack, theme, x, y, w, h);
        this.drawIcon(matrixStack, theme, x + (w - s) / 2, y + (h - s) / 2, s, s);
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public abstract void onClicked(MouseButton var1);

    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        return new WrappedIngredient(this.icon.getIngredient()).tooltip();
    }
}

