/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;

public class CheckBoxList
extends Button {
    public final boolean radioButtons;
    private final List<CheckBoxEntry> entries;

    public CheckBoxList(GuiBase gui, boolean radiobutton) {
        super(gui);
        this.setSize(10, 2);
        this.radioButtons = radiobutton;
        this.entries = new ArrayList<CheckBoxEntry>();
    }

    public int getValueCount() {
        return 2;
    }

    @Override
    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
    }

    public void drawCheckboxBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        theme.drawCheckboxBackground(matrixStack, x, y, w, h, this.radioButtons);
    }

    public void getCheckboxIcon(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h, int index, int value) {
        theme.drawCheckbox(matrixStack, x, y, w, h, WidgetType.mouseOver(this.isMouseOver()), value != 0, this.radioButtons);
    }

    public void addBox(CheckBoxEntry checkBox) {
        checkBox.checkBoxList = this;
        this.entries.add(checkBox);
        this.setWidth(Math.max(this.width, this.getGui().getTheme().getStringWidth(checkBox.name)));
        this.setHeight(this.height + 11);
    }

    public CheckBoxEntry addBox(String name) {
        CheckBoxEntry entry = new CheckBoxEntry(name);
        this.addBox(entry);
        return entry;
    }

    @Override
    public void onClicked(MouseButton button) {
        int y = this.getMouseY() - this.getY();
        if (y % 11 == 10) {
            return;
        }
        int i = y / 11;
        if (i >= 0 && i < this.entries.size()) {
            this.entries.get(i).onClicked(button, i);
        }
    }

    @Override
    public void addMouseOverText(TooltipList list) {
    }

    @Override
    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        this.drawBackground(matrixStack, theme, x, y, w, h);
        for (int i = 0; i < this.entries.size(); ++i) {
            CheckBoxEntry entry = this.entries.get(i);
            int ey = y + i * 11 + 1;
            this.drawCheckboxBackground(matrixStack, theme, x, ey, 10, 10);
            this.getCheckboxIcon(matrixStack, theme, x + 1, ey + 1, 8, 8, i, entry.value);
            theme.drawString(matrixStack, entry.name, x + 12, ey + 1);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static class CheckBoxEntry {
        public String name;
        public int value = 0;
        private CheckBoxList checkBoxList;

        public CheckBoxEntry(String n) {
            this.name = n;
        }

        public void onClicked(MouseButton button, int index) {
            this.select((this.value + 1) % this.checkBoxList.getValueCount());
            this.checkBoxList.playClickSound();
        }

        public void addMouseOverText(List<String> list) {
        }

        public CheckBoxEntry select(int v) {
            if (this.checkBoxList.radioButtons) {
                if (v > 0) {
                    for (CheckBoxEntry entry : this.checkBoxList.entries) {
                        boolean old1 = entry.value > 0;
                        entry.value = 0;
                        if (!old1) continue;
                        entry.onValueChanged();
                    }
                } else {
                    return this;
                }
            }
            int old = this.value;
            this.value = v;
            if (old != this.value) {
                this.onValueChanged();
            }
            return this;
        }

        public void onValueChanged() {
        }
    }
}

