/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetLayout;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class ContextMenu
extends Panel {
    public final List<ContextMenuItem> items;
    public boolean hasIcons;

    public ContextMenu(Panel panel, List<ContextMenuItem> i) {
        super(panel);
        this.items = i;
        this.hasIcons = false;
        for (ContextMenuItem item : this.items) {
            if (item.icon.isEmpty()) continue;
            this.hasIcons = true;
            break;
        }
    }

    @Override
    public void addWidgets() {
        for (ContextMenuItem item : this.items) {
            this.add(item.createWidget(this));
        }
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        boolean b = super.mousePressed(button);
        if (!b && !this.isMouseOver()) {
            this.closeContextMenu();
            return true;
        }
        return b;
    }

    @Override
    public void alignWidgets() {
        this.setWidth(0);
        for (Widget widget : this.widgets) {
            this.setWidth(Math.max(this.width, widget.width));
        }
        for (Widget widget : this.widgets) {
            widget.setX(3);
            widget.setWidth(this.width);
        }
        this.setWidth(this.width + 6);
        this.setHeight(this.align(new WidgetLayout.Vertical(3, 1, 3)));
    }

    @Override
    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        theme.drawContextMenuBackground(matrixStack, x, y, w, h);
    }

    @Override
    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 900.0);
        super.draw(matrixStack, theme, x, y, w, h);
        matrixStack.func_227865_b_();
    }

    public static class CSeperator
    extends Button {
        public CSeperator(Panel panel) {
            super(panel);
            this.setHeight(5);
        }

        @Override
        public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
            Color4I.WHITE.withAlpha(130).draw(matrixStack, x + 2, y + 2, this.parent.width - 10, 1);
        }

        @Override
        public void onClicked(MouseButton button) {
        }
    }

    public static class CButton
    extends Button {
        public final ContextMenu contextMenu;
        public final ContextMenuItem item;

        public CButton(ContextMenu panel, ContextMenuItem i) {
            super(panel, i.title, i.icon);
            this.contextMenu = panel;
            this.item = i;
            this.setSize(panel.getGui().getTheme().getStringWidth((ITextProperties)this.item.title) + (this.contextMenu.hasIcons ? 14 : 4), 12);
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            this.item.addMouseOverText(list);
        }

        @Override
        public WidgetType getWidgetType() {
            return this.item.enabled.getAsBoolean() ? super.getWidgetType() : WidgetType.DISABLED;
        }

        @Override
        public void drawIcon(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
            this.item.drawIcon(matrixStack, theme, x, y, w, h);
        }

        @Override
        public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
            if (this.contextMenu.hasIcons) {
                this.drawIcon(matrixStack, theme, x + 1, y + 2, 8, 8);
                theme.drawString(matrixStack, this.getTitle(), x + 11, y + 2, theme.getContentColor(this.getWidgetType()), 2);
            } else {
                theme.drawString(matrixStack, this.getTitle(), x + 2, y + 2, theme.getContentColor(this.getWidgetType()), 2);
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (this.item.yesNoText.getString().isEmpty()) {
                this.item.onClicked(this.contextMenu, button);
            } else {
                this.getGui().openYesNo(this.item.yesNoText, (ITextComponent)new StringTextComponent(""), () -> this.item.onClicked(this.contextMenu, button));
            }
        }
    }
}

