/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenu;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ContextMenuItem
implements Comparable<ContextMenuItem> {
    public static final ContextMenuItem SEPARATOR = new ContextMenuItem(StringTextComponent.field_240750_d_, Icon.EMPTY, () -> {}){

        @Override
        public Widget createWidget(ContextMenu panel) {
            return new ContextMenu.CSeperator(panel);
        }
    };
    public static final BooleanSupplier TRUE = () -> true;
    public static final BooleanSupplier FALSE = () -> false;
    public ITextComponent title;
    public Icon icon;
    public Runnable callback;
    public BooleanSupplier enabled = TRUE;
    public ITextComponent yesNoText = new StringTextComponent("");
    public boolean closeMenu = true;

    public ContextMenuItem(ITextComponent t, Icon i, @Nullable Runnable c) {
        this.title = t;
        this.icon = i;
        this.callback = c;
    }

    public void addMouseOverText(TooltipList list) {
    }

    public void drawIcon(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        this.icon.draw(matrixStack, x, y, w, h);
    }

    public ContextMenuItem setEnabled(boolean v) {
        return this.setEnabled(v ? TRUE : FALSE);
    }

    public ContextMenuItem setEnabled(BooleanSupplier v) {
        this.enabled = v;
        return this;
    }

    public ContextMenuItem setYesNo(ITextComponent s) {
        this.yesNoText = s;
        return this;
    }

    public ContextMenuItem setCloseMenu(boolean v) {
        this.closeMenu = v;
        return this;
    }

    public Widget createWidget(ContextMenu panel) {
        return new ContextMenu.CButton(panel, this);
    }

    @Override
    public int compareTo(ContextMenuItem o) {
        return this.title.getString().compareToIgnoreCase(o.title.getString());
    }

    public void onClicked(Panel panel, MouseButton button) {
        if (this.closeMenu) {
            panel.getGui().closeContextMenu();
        }
        this.callback.run();
    }
}

