/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.KeyModifiers;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.feed_the_beast.mods.ftbguilibrary.widget.IGuiWrapper;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.WrappedIngredient;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class GuiContainerWrapper
extends ContainerScreen
implements IGuiWrapper {
    private final GuiBase wrappedGui;
    private boolean drawSlots = true;
    private final TooltipList tooltipList = new TooltipList();

    public GuiContainerWrapper(GuiBase g, Container c, PlayerInventory playerInventory, ITextComponent title) {
        super(c, playerInventory, title);
        this.wrappedGui = g;
    }

    public GuiContainerWrapper disableSlotDrawing() {
        this.drawSlots = false;
        return this;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.wrappedGui.initGui();
        this.field_147003_i = this.wrappedGui.getX();
        this.field_147009_r = this.wrappedGui.getY();
        this.field_146999_f = this.wrappedGui.width;
        this.field_147000_g = this.wrappedGui.height;
    }

    public boolean func_231177_au__() {
        return this.wrappedGui.doesGuiPauseGame();
    }

    public boolean func_231044_a_(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        if (button == MouseButton.BACK.id) {
            this.wrappedGui.onBack();
            return true;
        }
        this.wrappedGui.mousePressed(MouseButton.get(button));
        return super.func_231044_a_(x, y, button);
    }

    public boolean func_231048_c_(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        this.wrappedGui.mouseReleased(MouseButton.get(button));
        return super.func_231048_c_(x, y, button);
    }

    public boolean func_231043_a_(double x, double y, double scroll) {
        this.wrappedGui.mouseScrolled(scroll);
        return super.func_231043_a_(x, y, scroll);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        if (this.wrappedGui.keyPressed(key)) {
            return true;
        }
        if (key.backspace()) {
            this.wrappedGui.onBack();
        } else if (this.wrappedGui.onClosedByKey(key)) {
            this.wrappedGui.closeGui(false);
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        this.wrappedGui.keyReleased(key);
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char keyChar, int modifiers) {
        if (this.wrappedGui.charTyped(keyChar, new KeyModifiers(modifiers))) {
            return true;
        }
        return super.func_231042_a_(keyChar, (int)keyChar);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float f, int mx, int my) {
        Theme theme = this.wrappedGui.getTheme();
        GuiHelper.setupDrawing();
        this.func_230446_a_(matrixStack);
        GuiHelper.setupDrawing();
        this.wrappedGui.draw(matrixStack, theme, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        if (this.drawSlots) {
            GuiHelper.setupDrawing();
            for (Slot slot : this.field_147002_h.field_75151_b) {
                theme.drawContainerSlot(matrixStack, this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, 16, 16);
            }
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(-this.field_147003_i), (double)(-this.field_147009_r), 0.0);
        GuiHelper.setupDrawing();
        Theme theme = this.wrappedGui.getTheme();
        this.wrappedGui.drawForeground(matrixStack, theme, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        if (this.wrappedGui.contextMenu != null) {
            this.wrappedGui.contextMenu.addMouseOverText(this.tooltipList);
        } else {
            this.wrappedGui.addMouseOverText(this.tooltipList);
        }
        if (!this.tooltipList.shouldRender()) {
            Object ingredient;
            Object object = this.wrappedGui.getIngredientUnderMouse();
            if (object instanceof WrappedIngredient && ((WrappedIngredient)object).tooltip && (ingredient = WrappedIngredient.unwrap(object)) instanceof ItemStack && !((ItemStack)ingredient).func_190926_b()) {
                this.func_230457_a_(matrixStack, (ItemStack)ingredient, mouseX, mouseY);
            }
        } else {
            this.tooltipList.render(matrixStack, mouseX, Math.max(mouseY, 18), this.wrappedGui.getScreen().func_198107_o(), this.wrappedGui.getScreen().func_198087_p(), 0, theme.getFont());
        }
        this.tooltipList.reset();
        if (this.wrappedGui.contextMenu == null) {
            this.func_230459_a_(matrixStack, mouseX, mouseY);
        }
        matrixStack.func_227865_b_();
    }

    public void func_230446_a_(MatrixStack matrixStack) {
        if (this.wrappedGui.drawDefaultBackground(matrixStack)) {
            super.func_230446_a_(matrixStack);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.wrappedGui.updateGui(mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.wrappedGui.tick();
    }

    @Override
    public GuiBase getGui() {
        return this.wrappedGui;
    }

    public void func_231164_f_() {
        this.wrappedGui.onClosed();
        super.func_231164_f_();
    }
}

