/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.KeyModifiers;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.feed_the_beast.mods.ftbguilibrary.widget.IGuiWrapper;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.WrappedIngredient;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.ModList;

public class GuiWrapper
extends Screen
implements IGuiWrapper {
    private final GuiBase wrappedGui;
    private final TooltipList tooltipList = new TooltipList();

    public GuiWrapper(GuiBase g) {
        super(g.getTitle());
        this.wrappedGui = g;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.wrappedGui.itemRenderer = this.field_230707_j_;
        this.wrappedGui.initGui();
    }

    public boolean func_231177_au__() {
        return this.wrappedGui.doesGuiPauseGame();
    }

    public boolean func_231044_a_(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        if (button == MouseButton.BACK.id) {
            this.wrappedGui.onBack();
            return true;
        }
        this.wrappedGui.mousePressed(MouseButton.get(button));
        return super.func_231044_a_(x, y, button);
    }

    public boolean func_231048_c_(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        this.wrappedGui.mouseReleased(MouseButton.get(button));
        return super.func_231048_c_(x, y, button);
    }

    public boolean func_231043_a_(double x, double y, double scroll) {
        this.wrappedGui.mouseScrolled(scroll);
        return super.func_231043_a_(x, y, scroll);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        Object object;
        Key key = new Key(keyCode, scanCode, modifiers);
        if (this.wrappedGui.keyPressed(key)) {
            return true;
        }
        if (key.backspace()) {
            this.wrappedGui.onBack();
        } else if (this.wrappedGui.onClosedByKey(key)) {
            this.wrappedGui.closeGui(false);
        } else if (ModList.get().isLoaded("jei") && (object = WrappedIngredient.unwrap(this.wrappedGui.getIngredientUnderMouse())) != null) {
            this.handleIngredientKey(key, object);
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        this.wrappedGui.keyReleased(key);
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char keyChar, int modifiers) {
        if (this.wrappedGui.charTyped(keyChar, new KeyModifiers(modifiers))) {
            return true;
        }
        return super.func_231042_a_(keyChar, (int)keyChar);
    }

    private void handleIngredientKey(Key key, Object object) {
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.wrappedGui.updateGui(mouseX, mouseY, partialTicks);
        this.func_230446_a_(matrixStack);
        GuiHelper.setupDrawing();
        int x = this.wrappedGui.getX();
        int y = this.wrappedGui.getY();
        int w = this.wrappedGui.width;
        int h = this.wrappedGui.height;
        Theme theme = this.wrappedGui.getTheme();
        this.wrappedGui.draw(matrixStack, theme, x, y, w, h);
        this.wrappedGui.drawForeground(matrixStack, theme, x, y, w, h);
        if (this.wrappedGui.contextMenu != null) {
            this.wrappedGui.contextMenu.addMouseOverText(this.tooltipList);
        } else {
            this.wrappedGui.addMouseOverText(this.tooltipList);
        }
        if (!this.tooltipList.shouldRender()) {
            Object ingredient;
            Object object = this.wrappedGui.getIngredientUnderMouse();
            if (object instanceof WrappedIngredient && ((WrappedIngredient)object).tooltip && (ingredient = WrappedIngredient.unwrap(object)) instanceof ItemStack && !((ItemStack)ingredient).func_190926_b()) {
                this.func_230457_a_(matrixStack, (ItemStack)ingredient, mouseX, mouseY);
            }
        } else {
            this.tooltipList.render(matrixStack, mouseX, Math.max(mouseY, 18), this.wrappedGui.getScreen().func_198107_o(), this.wrappedGui.getScreen().func_198087_p(), 0, theme.getFont());
        }
        this.tooltipList.reset();
    }

    public void func_230446_a_(MatrixStack matrixStack) {
        if (this.wrappedGui.drawDefaultBackground(matrixStack)) {
            super.func_230446_a_(matrixStack);
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.wrappedGui.tick();
    }

    @Override
    public GuiBase getGui() {
        return this.wrappedGui;
    }

    public void func_231164_f_() {
        this.wrappedGui.onClosed();
        super.func_231164_f_();
    }
}

