/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public abstract class SimpleTextButton
extends Button {
    public SimpleTextButton(Panel panel, ITextComponent txt, Icon icon) {
        super(panel, txt, icon);
        this.setWidth(panel.getGui().getTheme().getStringWidth((ITextProperties)txt) + (this.hasIcon() ? 28 : 8));
        this.setHeight(20);
    }

    @Override
    public SimpleTextButton setTitle(ITextComponent txt) {
        super.setTitle(txt);
        this.setWidth(this.getGui().getTheme().getStringWidth((ITextProperties)this.getTitle()) + (this.hasIcon() ? 28 : 8));
        return this;
    }

    public boolean renderTitleInCenter() {
        return false;
    }

    @Override
    public Object getIngredientUnderMouse() {
        return this.icon.getIngredient();
    }

    public boolean hasIcon() {
        return !this.icon.isEmpty();
    }

    @Override
    public void addMouseOverText(TooltipList list) {
        if (this.getGui().getTheme().getStringWidth((ITextProperties)this.getTitle()) + (this.hasIcon() ? 28 : 8) > this.width) {
            list.add(this.getTitle());
        }
    }

    @Override
    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        this.drawBackground(matrixStack, theme, x, y, w, h);
        int s = h >= 16 ? 16 : 8;
        int off = (h - s) / 2;
        ITextComponent title = this.getTitle();
        int textX = x;
        int textY = y + (h - theme.getFontHeight() + 1) / 2;
        int sw = theme.getStringWidth((ITextProperties)title);
        int mw = w - (this.hasIcon() ? off + s : 0) - 6;
        if (sw > mw) {
            sw = mw;
            title = theme.trimStringToWidth((ITextProperties)title, mw);
        }
        textX = this.renderTitleInCenter() ? (textX += (mw - sw + 6) / 2) : (textX += 4);
        if (this.hasIcon()) {
            this.drawIcon(matrixStack, theme, x + off, y + off, s, s);
            textX += off + s;
        }
        theme.drawString(matrixStack, title, textX, textY, theme.getContentColor(this.getWidgetType()), 2);
    }
}

