/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.Bits;
import com.feed_the_beast.mods.ftbguilibrary.utils.StringUtils;
import com.feed_the_beast.mods.ftbguilibrary.utils.TooltipList;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class TextField
extends Widget {
    public String[] text;
    public int textFlags = 0;
    public int maxWidth = 0;
    public int textSpacing = 10;
    public float scale = 1.0f;
    public Color4I textColor = Icon.EMPTY;

    public TextField(Panel panel) {
        super(panel);
    }

    public TextField addFlags(int flags) {
        this.textFlags |= flags;
        return this;
    }

    public TextField setMaxWidth(int width) {
        this.maxWidth = width;
        return this;
    }

    public TextField setColor(Color4I color) {
        this.textColor = color;
        return this;
    }

    public TextField setScale(float s) {
        this.scale = s;
        return this;
    }

    public TextField setSpacing(int s) {
        this.textSpacing = s;
        return this;
    }

    public TextField setText(String txt) {
        this.text = null;
        txt = txt.trim();
        Theme theme = this.getGui().getTheme();
        if (!txt.isEmpty()) {
            this.text = this.maxWidth == 0 ? txt.split("\n") : (String[])theme.listFormattedStringToWidth((ITextProperties)new StringTextComponent(txt), this.maxWidth).stream().map(ITextProperties::getString).toArray(String[]::new);
        }
        if (this.text == null || this.text.length == 0) {
            this.text = StringUtils.EMPTY_ARRAY;
        }
        return this.resize(theme);
    }

    public TextField resize(Theme theme) {
        if (this.maxWidth == 0) {
            this.setWidth(0);
            for (String s : this.text) {
                this.setWidth(Math.max(this.width, (int)((float)theme.getStringWidth(s) * this.scale)));
            }
        } else {
            this.setWidth(this.maxWidth);
        }
        this.setHeight((int)((float)(Math.max(1, this.text.length) * this.textSpacing - (this.textSpacing - theme.getFontHeight() + 1)) * this.scale));
        return this;
    }

    @Override
    public void addMouseOverText(TooltipList list) {
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
    }

    @Override
    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        this.drawBackground(matrixStack, theme, x, y, w, h);
        if (this.text.length == 0) {
            return;
        }
        boolean centered = Bits.getFlag(this.textFlags, 4);
        boolean centeredV = Bits.getFlag(this.textFlags, 32);
        Color4I col = this.textColor;
        if (col.isEmpty()) {
            col = theme.getContentColor(WidgetType.mouseOver(Bits.getFlag(this.textFlags, 16)));
        }
        int tx = x + (centered ? w / 2 : 0);
        int ty = y + (centeredV ? (h - theme.getFontHeight()) / 2 : 0);
        if (this.scale == 1.0f) {
            for (int i = 0; i < this.text.length; ++i) {
                theme.drawString(matrixStack, this.text[i], tx, ty + i * this.textSpacing, col, this.textFlags);
            }
        } else {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)tx, (double)ty, 0.0);
            matrixStack.func_227862_a_(this.scale, this.scale, 1.0f);
            for (int i = 0; i < this.text.length; ++i) {
                theme.drawString(matrixStack, this.text[i], 0.0f, i * this.textSpacing, col, this.textFlags);
            }
            matrixStack.func_227865_b_();
        }
    }
}

