/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.ImageIcon;
import com.feed_the_beast.mods.ftbguilibrary.icon.PartIcon;
import com.feed_the_beast.mods.ftbguilibrary.utils.Bits;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public class Theme {
    public static final Theme DEFAULT = new Theme();
    public static boolean renderDebugBoxes = false;
    public static final int DARK = 1;
    public static final int SHADOW = 2;
    public static final int CENTERED = 4;
    public static final int UNICODE = 8;
    public static final int MOUSE_OVER = 16;
    public static final int CENTERED_V = 32;
    private static final Color4I CONTENT_COLOR_MOUSE_OVER = Color4I.rgb(0xFFFFA0);
    private static final Color4I CONTENT_COLOR_DISABLED = Color4I.rgb(0xA0A0A0);
    private static final Color4I CONTENT_COLOR_DARK = Color4I.rgb(0x404040);
    public static final ImageIcon BACKGROUND_SQUARES = (ImageIcon)Icon.getIcon("ftbguilibrary:textures/gui/background_squares.png");
    private static final ImageIcon TEXTURE_BEACON = (ImageIcon)Icon.getIcon("textures/gui/container/beacon.png");
    private static final ImageIcon TEXTURE_WIDGETS = (ImageIcon)Icon.getIcon("textures/gui/widgets.png");
    private static final ImageIcon TEXTURE_RECIPE_BOOK = (ImageIcon)Icon.getIcon("textures/gui/recipe_book.png");
    private static final ImageIcon TEXTURE_ENCHANTING_TABLE = (ImageIcon)Icon.getIcon("textures/gui/container/enchanting_table.png");
    private static final Icon GUI = new PartIcon(TEXTURE_RECIPE_BOOK, 82, 208, 32, 32, 8);
    private static final Icon GUI_MOUSE_OVER = GUI.withTint(Color4I.rgb(11515610));
    private static final Icon BUTTON = new PartIcon(TEXTURE_WIDGETS, 0, 66, 200, 20, 4);
    private static final Icon BUTTON_MOUSE_OVER = new PartIcon(TEXTURE_WIDGETS, 0, 86, 200, 20, 4);
    private static final Icon BUTTON_DISABLED = new PartIcon(TEXTURE_WIDGETS, 0, 46, 200, 20, 4);
    private static final Icon WIDGET = new PartIcon(TEXTURE_BEACON, 0, 219, 22, 22, 6);
    private static final Icon WIDGET_MOUSE_OVER = new PartIcon(TEXTURE_BEACON, 66, 219, 22, 22, 6);
    private static final Icon WIDGET_DISABLED = new PartIcon(TEXTURE_BEACON, 44, 219, 22, 22, 6);
    private static final Icon SLOT = new PartIcon(TEXTURE_BEACON, 35, 136, 18, 18, 3);
    private static final Icon SLOT_MOUSE_OVER = SLOT.combineWith((Icon)Color4I.WHITE.withAlpha(33));
    private static final Icon SCROLL_BAR_BG = SLOT;
    private static final Icon SCROLL_BAR_BG_DISABLED = SCROLL_BAR_BG.withTint(Color4I.BLACK.withAlpha(100));
    private static final Icon TEXT_BOX = new PartIcon(TEXTURE_ENCHANTING_TABLE, 0, 185, 108, 19, 6);
    private static final Icon TAB_H_UNSELECTED = TEXTURE_RECIPE_BOOK.withUV(150.0f, 2.0f, 35.0f, 26.0f, 256.0f, 256.0f);
    private static final Icon TAB_H_SELECTED = TEXTURE_RECIPE_BOOK.withUV(188.0f, 2.0f, 35.0f, 26.0f, 256.0f, 256.0f);
    private final BooleanStack fontUnicode = new BooleanArrayList();

    public Color4I getContentColor(WidgetType type) {
        return type == WidgetType.MOUSE_OVER ? CONTENT_COLOR_MOUSE_OVER : (type == WidgetType.DISABLED ? CONTENT_COLOR_DISABLED : Color4I.WHITE);
    }

    public Color4I getInvertedContentColor() {
        return CONTENT_COLOR_DARK;
    }

    public void drawGui(MatrixStack matrixStack, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.MOUSE_OVER ? GUI_MOUSE_OVER : GUI).draw(matrixStack, x, y, w, h);
    }

    public void drawWidget(MatrixStack matrixStack, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.MOUSE_OVER ? WIDGET_MOUSE_OVER : (type == WidgetType.DISABLED ? WIDGET_DISABLED : WIDGET)).draw(matrixStack, x, y, w, h);
    }

    public void drawSlot(MatrixStack matrixStack, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.MOUSE_OVER ? SLOT_MOUSE_OVER : SLOT).draw(matrixStack, x, y, w, h);
    }

    public void drawContainerSlot(MatrixStack matrixStack, int x, int y, int w, int h) {
        SLOT.draw(matrixStack, x - 1, y - 1, w + 2, h + 2);
    }

    public void drawButton(MatrixStack matrixStack, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.MOUSE_OVER ? BUTTON_MOUSE_OVER : (type == WidgetType.DISABLED ? BUTTON_DISABLED : BUTTON)).draw(matrixStack, x, y, w, h);
    }

    public void drawScrollBarBackground(MatrixStack matrixStack, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.DISABLED ? SCROLL_BAR_BG_DISABLED : SCROLL_BAR_BG).draw(matrixStack, x, y, w, h);
    }

    public void drawScrollBar(MatrixStack matrixStack, int x, int y, int w, int h, WidgetType type, boolean vertical) {
        (type == WidgetType.MOUSE_OVER ? WIDGET_MOUSE_OVER : WIDGET).draw(matrixStack, x + 1, y + 1, w - 2, h - 2);
    }

    public void drawTextBox(MatrixStack matrixStack, int x, int y, int w, int h) {
        TEXT_BOX.draw(matrixStack, x, y, w, h);
    }

    public void drawCheckboxBackground(MatrixStack matrixStack, int x, int y, int w, int h, boolean radioButton) {
        this.drawSlot(matrixStack, x, y, w, h, WidgetType.NORMAL);
    }

    public void drawCheckbox(MatrixStack matrixStack, int x, int y, int w, int h, WidgetType type, boolean selected, boolean radioButton) {
        if (selected) {
            this.drawWidget(matrixStack, x, y, w, h, type);
        }
    }

    public void drawPanelBackground(MatrixStack matrixStack, int x, int y, int w, int h) {
        this.drawContainerSlot(matrixStack, x, y, w, h);
    }

    public void drawHorizontalTab(MatrixStack matrixStack, int x, int y, int w, int h, boolean selected) {
        (selected ? TAB_H_SELECTED : TAB_H_UNSELECTED).draw(matrixStack, x, y, w, h);
    }

    public void drawContextMenuBackground(MatrixStack matrixStack, int x, int y, int w, int h) {
        this.drawGui(matrixStack, x, y, w, h, WidgetType.NORMAL);
        Color4I.BLACK.withAlpha(90).draw(matrixStack, x, y, w, h);
    }

    public FontRenderer getFont() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public final int getStringWidth(ITextProperties text) {
        return text == StringTextComponent.field_240750_d_ ? 0 : this.getFont().func_238414_a_(text);
    }

    public final int getStringWidth(IReorderingProcessor text) {
        return text == IReorderingProcessor.field_242232_a ? 0 : this.getFont().func_243245_a(text);
    }

    public final int getStringWidth(String text) {
        return text.isEmpty() ? 0 : this.getFont().func_78256_a(text);
    }

    public final int getFontHeight() {
        this.getFont().getClass();
        return 9;
    }

    public final String trimStringToWidth(String text, int width) {
        return text.isEmpty() || width <= 0 ? "" : this.getFont().func_238413_a_(text, width, false);
    }

    public final ITextProperties trimStringToWidth(ITextProperties text, int width) {
        return this.getFont().func_238417_a_(text, width);
    }

    public final String trimStringToWidthReverse(String text, int width) {
        return text.isEmpty() || width <= 0 ? "" : this.getFont().func_238413_a_(text, width, true);
    }

    public final List<ITextProperties> listFormattedStringToWidth(ITextProperties text, int width) {
        if (width <= 0 || text == StringTextComponent.field_240750_d_) {
            return Collections.emptyList();
        }
        return this.getFont().func_238420_b_().func_238362_b_(text, width, Style.field_240709_b_);
    }

    public final int drawString(MatrixStack matrixStack, @Nullable Object text, float x, float y, Color4I color, int flags) {
        if (text == null || text == IReorderingProcessor.field_242232_a || text == StringTextComponent.field_240750_d_ || text instanceof String && ((String)text).isEmpty() || color.isEmpty()) {
            return 0;
        }
        if (text instanceof IReorderingProcessor) {
            if (Bits.getFlag(flags, 4)) {
                x -= (float)this.getStringWidth((IReorderingProcessor)text) / 2.0f;
            }
            int i = Bits.getFlag(flags, 2) ? this.getFont().func_238407_a_(matrixStack, (IReorderingProcessor)text, x, y, color.rgba()) : this.getFont().func_238422_b_(matrixStack, (IReorderingProcessor)text, x, y, color.rgba());
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableAlphaTest();
            RenderSystem.enableBlend();
            return i;
        }
        if (text instanceof ITextComponent) {
            if (Bits.getFlag(flags, 4)) {
                x -= (float)this.getStringWidth((ITextProperties)((ITextComponent)text)) / 2.0f;
            }
            int i = Bits.getFlag(flags, 2) ? this.getFont().func_243246_a(matrixStack, (ITextComponent)text, x, y, color.rgba()) : this.getFont().func_243248_b(matrixStack, (ITextComponent)text, x, y, color.rgba());
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableAlphaTest();
            RenderSystem.enableBlend();
            return i;
        }
        if (text instanceof ITextProperties) {
            return this.drawString(matrixStack, LanguageMap.func_74808_a().func_241870_a((ITextProperties)text), x, y, color, flags);
        }
        String s = String.valueOf(text);
        if (Bits.getFlag(flags, 4)) {
            x -= (float)this.getStringWidth(s) / 2.0f;
        }
        int i = Bits.getFlag(flags, 2) ? this.getFont().func_238405_a_(matrixStack, s, x, y, color.rgba()) : this.getFont().func_238421_b_(matrixStack, s, x, y, color.rgba());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        return i;
    }

    public final int drawString(MatrixStack matrixStack, @Nullable Object text, int x, int y, int flags) {
        return this.drawString(matrixStack, text, x, y, this.getContentColor(WidgetType.mouseOver(Bits.getFlag(flags, 16))), flags);
    }

    public final int drawString(MatrixStack matrixStack, @Nullable Object text, int x, int y) {
        return this.drawString(matrixStack, text, x, y, this.getContentColor(WidgetType.NORMAL), 0);
    }
}

