/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.item;

import dev.latvian.mods.itemfilters.ItemFilters;
import dev.latvian.mods.itemfilters.api.FilterInfo;
import dev.latvian.mods.itemfilters.api.IStringValueFilter;
import dev.latvian.mods.itemfilters.item.BaseFilterItem;
import dev.latvian.mods.itemfilters.item.StringValueData;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class StringValueFilterItem
extends BaseFilterItem
implements IStringValueFilter {
    public <T extends StringValueData> T getStringValueData(ItemStack filter) {
        return (T)((StringValueData)filter.getCapability(StringValueData.CAPABILITY).orElseThrow(NullPointerException::new));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return this.createData(stack);
    }

    public abstract StringValueData createData(ItemStack var1);

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            ItemFilters.instance.proxy.openStringValueFilterScreen(this, stack, hand);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    public String getValue(ItemStack filter) {
        return filter.func_77942_o() ? filter.func_77978_p().func_74779_i("value") : "";
    }

    @Override
    public void setValue(ItemStack filter, String v) {
        Object data = this.getStringValueData(filter);
        ((StringValueData)data).setValueFromString(v);
    }

    @Override
    public void resetFilterData(ItemStack filter) {
        Object data = this.getStringValueData(filter);
        ((StringValueData)data).setValue(null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addInfo(ItemStack filter, FilterInfo info, boolean expanded) {
        String s = this.getValue(filter);
        if (!s.isEmpty()) {
            info.add((ITextComponent)new StringTextComponent(s));
        }
    }
}

