/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.config;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigNumber;
import com.feed_the_beast.mods.ftbguilibrary.utils.StringUtils;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;

public class ConfigDouble
extends ConfigNumber<Double> {
    public ConfigDouble(double mn, double mx) {
        super(mn, mx);
    }

    @Override
    public void addInfo(List<String> list) {
        super.addInfo(list);
        if ((Double)this.min != Double.NEGATIVE_INFINITY) {
            list.add(TextFormatting.AQUA + "Min: " + TextFormatting.RESET + StringUtils.formatDouble((Double)this.min));
        }
        if ((Double)this.max != Double.POSITIVE_INFINITY) {
            list.add(TextFormatting.AQUA + "Max: " + TextFormatting.RESET + StringUtils.formatDouble((Double)this.max));
        }
    }

    @Override
    public String getStringFromValue(@Nullable Double v) {
        if (v == null) {
            return "null";
        }
        if (v == Double.POSITIVE_INFINITY) {
            return "+Inf";
        }
        if (v == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        return super.getStringFromValue(v);
    }

    @Override
    public boolean parse(@Nullable Consumer<Double> callback, String string) {
        if (string.equals("+Inf")) {
            if ((Double)this.max == Double.POSITIVE_INFINITY) {
                if (callback != null) {
                    callback.accept(Double.POSITIVE_INFINITY);
                }
                return true;
            }
            return false;
        }
        if (string.equals("-Inf")) {
            if ((Double)this.min == Double.NEGATIVE_INFINITY) {
                if (callback != null) {
                    callback.accept(Double.NEGATIVE_INFINITY);
                }
                return true;
            }
            return false;
        }
        try {
            double multiplier = 1.0;
            if (string.endsWith("K")) {
                multiplier = 1000.0;
                string = string.substring(0, string.length() - 1);
            } else if (string.endsWith("M")) {
                multiplier = 1000000.0;
                string = string.substring(0, string.length() - 1);
            } else if (string.endsWith("B")) {
                multiplier = 1.0E9;
                string = string.substring(0, string.length() - 1);
            }
            double v = Double.parseDouble(string.trim()) * multiplier;
            if (v >= (Double)this.min && v <= (Double)this.max) {
                if (callback != null) {
                    callback.accept(v);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

