/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import com.feed_the_beast.mods.ftbguilibrary.widget.WrappedIngredient;
import javax.annotation.Nullable;

public abstract class Button
extends Widget {
    protected String title;
    protected Icon icon;

    public Button(Panel panel, String t, Icon i) {
        super(panel);
        this.setSize(16, 16);
        this.icon = i;
        this.title = t;
    }

    public Button(Panel panel) {
        this(panel, "", Icon.EMPTY);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public Button setTitle(String s) {
        this.title = s;
        return this;
    }

    public Button setIcon(Icon i) {
        this.icon = i;
        return this;
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        theme.drawButton(x, y, w, h, this.getWidgetType());
    }

    public void drawIcon(Theme theme, int x, int y, int w, int h) {
        this.icon.draw(x, y, w, h);
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        int s = h >= 16 ? 16 : 8;
        this.drawBackground(theme, x, y, w, h);
        this.drawIcon(theme, x + (w - s) / 2, y + (h - s) / 2, s, s);
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public abstract void onClicked(MouseButton var1);

    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        return new WrappedIngredient(this.icon.getIngredient()).tooltip();
    }
}

