/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.item;

import dev.latvian.mods.itemfilters.api.FilterInfo;
import dev.latvian.mods.itemfilters.api.StringValueFilterVariant;
import dev.latvian.mods.itemfilters.item.StringValueData;
import dev.latvian.mods.itemfilters.item.StringValueFilterItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemGroupFilterItem
extends StringValueFilterItem {
    private static Map<String, ItemGroup> groups = null;

    @Nullable
    private static ItemGroup getItemGroup(String v) {
        if (groups == null) {
            groups = new HashMap<String, ItemGroup>();
            for (ItemGroup group : ItemGroup.field_78032_a) {
                groups.put(group.func_200300_c(), group);
            }
        }
        return groups.get(v);
    }

    @Override
    public StringValueData createData(ItemStack stack) {
        return new ItemGroupData(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<StringValueFilterVariant> getValueVariants(ItemStack filter) {
        ArrayList<StringValueFilterVariant> variants = new ArrayList<StringValueFilterVariant>();
        for (ItemGroup t : ItemGroup.field_78032_a) {
            if (t == ItemGroup.field_78027_g || t == ItemGroup.field_78036_m) continue;
            StringValueFilterVariant variant = new StringValueFilterVariant(t.func_200300_c());
            variant.title = new TranslationTextComponent(t.func_78024_c(), new Object[0]);
            variant.icon = t.func_151244_d();
            variants.add(variant);
        }
        return variants;
    }

    @Override
    public boolean filter(ItemStack filter, ItemStack item) {
        ItemGroupData data = (ItemGroupData)this.getStringValueData(filter);
        if (data.getValue() == null) {
            return false;
        }
        for (ItemGroup t : item.func_77973_b().getCreativeTabs()) {
            if (t != data.getValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getValidFilterItems(ItemStack filter, List<ItemStack> list) {
        ItemGroupData data = (ItemGroupData)this.getStringValueData(filter);
        if (data.getValue() != null) {
            NonNullList allItems = NonNullList.func_191196_a();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                item.func_150895_a((ItemGroup)data.getValue(), allItems);
            }
            list.addAll((Collection<ItemStack>)allItems);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addInfo(ItemStack filter, FilterInfo info, boolean expanded) {
        ItemGroupData data = (ItemGroupData)this.getStringValueData(filter);
        if (data.getValue() != null) {
            info.add((ITextComponent)new TranslationTextComponent(((ItemGroup)data.getValue()).func_78024_c(), new Object[0]));
        }
    }

    public static class ItemGroupData
    extends StringValueData<ItemGroup> {
        public ItemGroupData(ItemStack is) {
            super(is);
        }

        @Override
        @Nullable
        protected ItemGroup fromString(String s) {
            return ItemGroupFilterItem.getItemGroup(s);
        }

        @Override
        protected String toString(ItemGroup value) {
            return value.func_200300_c();
        }
    }
}

