/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.item;

import dev.latvian.mods.itemfilters.item.StringValueData;
import dev.latvian.mods.itemfilters.item.StringValueFilterItem;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class MaxCountFilterItem
extends StringValueFilterItem {
    @Override
    public StringValueData createData(ItemStack stack) {
        return new MaxCountData(stack);
    }

    @Override
    public boolean filter(ItemStack filter, ItemStack item) {
        MaxCountData data = (MaxCountData)this.getStringValueData(filter);
        if (data.getValue() == null) {
            return false;
        }
        int d1 = item.func_77976_d();
        int d2 = ((MaxCountCheck)data.getValue()).maxCount;
        switch (((MaxCountCheck)data.getValue()).mode) {
            case 1: {
                return d1 >= d2;
            }
            case 2: {
                return d1 <= d2;
            }
            case 3: {
                return d1 > d2;
            }
            case 4: {
                return d1 < d2;
            }
        }
        return d1 == d2;
    }

    public static class MaxCountData
    extends StringValueData<MaxCountCheck> {
        public MaxCountData(ItemStack is) {
            super(is);
        }

        @Override
        @Nullable
        protected MaxCountCheck fromString(String s) {
            s = s.replaceAll("\\s", "");
            try {
                MaxCountCheck check = new MaxCountCheck();
                if (s.startsWith(">=")) {
                    check.mode = 1;
                    s = s.substring(2);
                } else if (s.startsWith("<=")) {
                    check.mode = 2;
                    s = s.substring(2);
                } else if (s.startsWith(">")) {
                    check.mode = 3;
                    s = s.substring(1);
                } else if (s.startsWith("<")) {
                    check.mode = 4;
                    s = s.substring(1);
                }
                check.maxCount = Integer.parseInt(s);
                return check;
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        protected String toString(MaxCountCheck value) {
            StringBuilder builder = new StringBuilder();
            switch (value.mode) {
                case 1: {
                    builder.append(">=");
                    break;
                }
                case 2: {
                    builder.append("<=");
                    break;
                }
                case 3: {
                    builder.append(">");
                    break;
                }
                case 4: {
                    builder.append("<");
                }
            }
            builder.append(value.maxCount);
            return builder.toString();
        }
    }

    public static class MaxCountCheck {
        public int mode;
        public int maxCount;
    }
}

