/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests;

import com.feed_the_beast.ftbquests.net.MessageEditObjectResponse;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.ftbquests.quest.reward.ItemReward;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FTBQuestsCommands {
    private static final Predicate<CommandSource> permission = s -> s.func_197028_i().func_71264_H() || s.func_197034_c(2);

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ftbquests").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"editing_mode").requires(permission)).executes(c -> FTBQuestsCommands.editingMode((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), null))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"mode", (ArgumentType)BoolArgumentType.bool()).requires(permission)).executes(c -> FTBQuestsCommands.editingMode((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), BoolArgumentType.getBool((CommandContext)c, (String)"mode")))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).requires(permission)).executes(c -> FTBQuestsCommands.editingMode((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"mode"))))))).then((ArgumentBuilder)Commands.func_197057_a((String)"change_progress"))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"export_rewards_to_chest").requires(permission)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"reward_table", (ArgumentType)StringArgumentType.word()).requires(permission)).executes(c -> FTBQuestsCommands.exportRewards((CommandSource)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"reward_table")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"import_rewards_from_chest").requires(permission)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"reward_table", (ArgumentType)StringArgumentType.word()).requires(permission)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"weight", (ArgumentType)IntegerArgumentType.integer((int)1)).requires(permission)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"replace", (ArgumentType)BoolArgumentType.bool()).requires(permission)).executes(c -> FTBQuestsCommands.importRewards((CommandSource)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"reward_table"), IntegerArgumentType.getInteger((CommandContext)c, (String)"weight"), BoolArgumentType.getBool((CommandContext)c, (String)"replace"))))).executes(c -> FTBQuestsCommands.importRewards((CommandSource)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"reward_table"), IntegerArgumentType.getInteger((CommandContext)c, (String)"weight"), false)))).executes(c -> FTBQuestsCommands.importRewards((CommandSource)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"reward_table"), 1, false)))));
    }

    private static int editingMode(CommandSource source, ServerPlayerEntity player, @Nullable Boolean canEdit) {
        PlayerData data = ServerQuestFile.INSTANCE.getData((Entity)player);
        if (canEdit == null) {
            canEdit = !data.getCanEdit();
        }
        data.setCanEdit(canEdit);
        if (canEdit.booleanValue()) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ftbquests.editing_mode.enabled", new Object[]{player.func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ftbquests.editing_mode.disabled", new Object[]{player.func_145748_c_()}), true);
        }
        return 1;
    }

    private static int changeProgress(CommandSource source, ServerPlayerEntity player, ChangeProgress type) {
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ftbquests.change_progress.text", new Object[0]), true);
        return 1;
    }

    private static RayTraceResult rayTrace(ServerPlayerEntity player) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vec3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return player.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
    }

    private static int importRewards(CommandSource source, String tableId, int weight, boolean replace) throws CommandSyntaxException {
        IItemHandler handler;
        TileEntity tileEntity;
        ServerPlayerEntity player = source.func_197035_h();
        RewardTable table = ServerQuestFile.INSTANCE.getRewardTable(tableId);
        RayTraceResult ray = FTBQuestsCommands.rayTrace(player);
        if (ray instanceof BlockRayTraceResult && (tileEntity = player.field_70170_p.func_175625_s(((BlockRayTraceResult)ray).func_216350_a())) != null && (handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, ((BlockRayTraceResult)ray).func_216354_b()).orElse(null)) != null) {
            if (replace) {
                table.rewards.clear();
            }
            int r = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                table.rewards.add(new WeightedReward(new ItemReward(table.fakeQuest, stack.func_77946_l()), weight));
                ++r;
            }
            ServerQuestFile.INSTANCE.clearCachedData();
            new MessageEditObjectResponse(table).sendToAll();
            ServerQuestFile.INSTANCE.save();
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ftbquests.import_rewards_from_chest.text", new Object[]{r, table.toString()}), true);
            return 1;
        }
        return 0;
    }

    private static int exportRewards(CommandSource source, String tableId) throws CommandSyntaxException {
        IItemHandler handler;
        TileEntity tileEntity;
        ServerPlayerEntity player = source.func_197035_h();
        RewardTable table = ServerQuestFile.INSTANCE.getRewardTable(tableId);
        RayTraceResult ray = FTBQuestsCommands.rayTrace(player);
        if (ray instanceof BlockRayTraceResult && (tileEntity = player.field_70170_p.func_175625_s(((BlockRayTraceResult)ray).func_216350_a())) != null && (handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, ((BlockRayTraceResult)ray).func_216354_b()).orElse(null)) != null) {
            int r = 0;
            for (WeightedReward reward : table.rewards) {
                Object object = reward.reward.getIngredient();
                if (!(object instanceof ItemStack) || ((ItemStack)object).func_190926_b()) continue;
                ItemStack stack1 = ((ItemStack)object).func_77946_l();
                stack1.func_190920_e(1);
                if (!ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack1, (boolean)false).func_190926_b()) continue;
                ++r;
            }
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ftbquests.export_rewards_to_chest.text", new Object[]{Integer.toString(r), Integer.toString(table.rewards.size()), table.toString()}), true);
        }
        return 0;
    }
}

