/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests;

import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.FTBQuestsCommands;
import com.feed_the_beast.ftbquests.events.ClearFileCacheEvent;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.item.ItemLootCrate;
import com.feed_the_beast.ftbquests.item.ItemQuestBook;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.reward.AdvancementReward;
import com.feed_the_beast.ftbquests.quest.reward.ChoiceReward;
import com.feed_the_beast.ftbquests.quest.reward.CommandReward;
import com.feed_the_beast.ftbquests.quest.reward.CustomReward;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.ItemReward;
import com.feed_the_beast.ftbquests.quest.reward.LootReward;
import com.feed_the_beast.ftbquests.quest.reward.RandomReward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.ftbquests.quest.reward.ToastReward;
import com.feed_the_beast.ftbquests.quest.reward.XPLevelsReward;
import com.feed_the_beast.ftbquests.quest.reward.XPReward;
import com.feed_the_beast.ftbquests.quest.task.AdvancementTask;
import com.feed_the_beast.ftbquests.quest.task.CheckmarkTask;
import com.feed_the_beast.ftbquests.quest.task.CustomTask;
import com.feed_the_beast.ftbquests.quest.task.DimensionTask;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.FluidTask;
import com.feed_the_beast.ftbquests.quest.task.ForgeEnergyTask;
import com.feed_the_beast.ftbquests.quest.task.ItemTask;
import com.feed_the_beast.ftbquests.quest.task.KillTask;
import com.feed_the_beast.ftbquests.quest.task.LocationTask;
import com.feed_the_beast.ftbquests.quest.task.ObservationTask;
import com.feed_the_beast.ftbquests.quest.task.StatTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.ftbquests.quest.task.XPTask;
import com.feed_the_beast.ftbquests.util.FTBQuestsInventoryListener;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Iterator;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FTBQuestsEventHandler {
    private List<KillTask> killTasks = null;
    private List<Task> autoSubmitTasks = null;

    public void init() {
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(this::worldSaved);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TaskType.class, this::registerTasks);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(RewardType.class, this::registerRewards);
        MinecraftForge.EVENT_BUS.addListener(this::fileCacheClear);
        MinecraftForge.EVENT_BUS.addListener(this::playerLoggedIn);
        MinecraftForge.EVENT_BUS.addListener(this::playerKill);
        MinecraftForge.EVENT_BUS.addListener(this::playerTick);
        MinecraftForge.EVENT_BUS.addListener(this::livingDrops);
        MinecraftForge.EVENT_BUS.addListener(this::itemCrafted);
        MinecraftForge.EVENT_BUS.addListener(this::itemSmelted);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::cloned);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::dropsEvent);
        MinecraftForge.EVENT_BUS.addListener(this::changedDimension);
        MinecraftForge.EVENT_BUS.addListener(this::containerOpened);
    }

    private void serverAboutToStart(FMLServerAboutToStartEvent event) {
        ServerQuestFile.INSTANCE = new ServerQuestFile(event.getServer());
    }

    private void serverStarting(FMLServerStartingEvent event) {
        FTBQuestsCommands.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    private void serverStarted(FMLServerStartedEvent event) {
        ServerQuestFile.INSTANCE.load();
    }

    private void serverStopped(FMLServerStoppedEvent event) {
        ServerQuestFile.INSTANCE.unload();
        ServerQuestFile.INSTANCE = null;
    }

    private void worldSaved(WorldEvent.Save event) {
        ServerQuestFile.INSTANCE.checkSave();
    }

    private void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ItemQuestBook().setRegistryName("book"), (Item)new ItemLootCrate().setRegistryName("lootcrate")});
    }

    private void registerTasks(RegistryEvent.Register<TaskType> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new TaskType[]{FTBQuestsTasks.ITEM = ((TaskType)new TaskType(ItemTask::new).setRegistryName("item")).setIcon(Icon.getIcon((String)"minecraft:item/diamond")), FTBQuestsTasks.FLUID = ((TaskType)new TaskType(FluidTask::new).setRegistryName("fluid")).setIcon(Icon.getIcon((String)Fluids.field_204546_a.getAttributes().getStillTexture(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).toString()).combineWith(Icon.getIcon((String)FluidTask.TANK_TEXTURE.toString()))), FTBQuestsTasks.FORGE_ENERGY = ((TaskType)new TaskType(ForgeEnergyTask::new).setRegistryName("forge_energy")).setIcon(Icon.getIcon((String)ForgeEnergyTask.EMPTY_TEXTURE.toString()).combineWith(Icon.getIcon((String)ForgeEnergyTask.FULL_TEXTURE.toString()))), FTBQuestsTasks.CUSTOM = ((TaskType)new TaskType(CustomTask::new).setRegistryName("custom")).setIcon(GuiIcons.COLOR_HSB), FTBQuestsTasks.XP = ((TaskType)new TaskType(XPTask::new).setRegistryName("xp")).setIcon(Icon.getIcon((String)"minecraft:item/experience_bottle")), FTBQuestsTasks.DIMENSION = ((TaskType)new TaskType(DimensionTask::new).setRegistryName("dimension")).setIcon(Icon.getIcon((String)"minecraft:block/nether_portal")), FTBQuestsTasks.STAT = ((TaskType)new TaskType(StatTask::new).setRegistryName("stat")).setIcon(Icon.getIcon((String)"minecraft:item/iron_sword")), FTBQuestsTasks.KILL = ((TaskType)new TaskType(KillTask::new).setRegistryName("kill")).setIcon(Icon.getIcon((String)"minecraft:item/diamond_sword")), FTBQuestsTasks.LOCATION = ((TaskType)new TaskType(LocationTask::new).setRegistryName("location")).setIcon(Icon.getIcon((String)"minecraft:item/compass_00")), FTBQuestsTasks.CHECKMARK = ((TaskType)new TaskType(CheckmarkTask::new).setRegistryName("checkmark")).setIcon(GuiIcons.ACCEPT_GRAY), FTBQuestsTasks.ADVANCEMENT = ((TaskType)new TaskType(AdvancementTask::new).setRegistryName("advancement")).setIcon(Icon.getIcon((String)"minecraft:item/wheat")), FTBQuestsTasks.OBSERVATION = ((TaskType)new TaskType(ObservationTask::new).setRegistryName("observation")).setIcon(GuiIcons.ART)});
        FTBQuests.PROXY.setTaskGuiProviders();
    }

    private void registerRewards(RegistryEvent.Register<RewardType> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new RewardType[]{FTBQuestsRewards.ITEM = ((RewardType)new RewardType(ItemReward::new).setRegistryName("item")).setIcon(Icon.getIcon((String)"minecraft:item/diamond")), FTBQuestsRewards.CHOICE = ((RewardType)new RewardType(ChoiceReward::new).setRegistryName("choice")).setIcon(GuiIcons.COLOR_RGB).setExcludeFromListRewards(true), FTBQuestsRewards.RANDOM = ((RewardType)new RewardType(RandomReward::new).setRegistryName("random")).setIcon(GuiIcons.DICE).setExcludeFromListRewards(true), FTBQuestsRewards.LOOT = ((RewardType)new RewardType(LootReward::new).setRegistryName("loot")).setIcon(GuiIcons.MONEY_BAG).setExcludeFromListRewards(true), FTBQuestsRewards.COMMAND = ((RewardType)new RewardType(CommandReward::new).setRegistryName("command")).setIcon(Icon.getIcon((String)"minecraft:block/command_block_back")), FTBQuestsRewards.CUSTOM = ((RewardType)new RewardType(CustomReward::new).setRegistryName("custom")).setIcon(GuiIcons.COLOR_HSB), FTBQuestsRewards.XP = ((RewardType)new RewardType(XPReward::new).setRegistryName("xp")).setIcon(Icon.getIcon((String)"minecraft:item/experience_bottle")), FTBQuestsRewards.XP_LEVELS = ((RewardType)new RewardType(XPLevelsReward::new).setRegistryName("xp_levels")).setIcon(Icon.getIcon((String)"minecraft:item/experience_bottle")), FTBQuestsRewards.ADVANCEMENT = ((RewardType)new RewardType(AdvancementReward::new).setRegistryName("advancement")).setIcon(Icon.getIcon((String)"minecraft:item/wheat")), FTBQuestsRewards.TOAST = ((RewardType)new RewardType(ToastReward::new).setRegistryName("toast")).setIcon(Icon.getIcon((String)"minecraft:item/oak_sign"))});
        FTBQuests.PROXY.setRewardGuiProviders();
    }

    private void fileCacheClear(ClearFileCacheEvent event) {
        this.killTasks = null;
        this.autoSubmitTasks = null;
    }

    private void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerQuestFile.INSTANCE.onLoggedIn((ServerPlayerEntity)event.getPlayer());
    }

    private void playerKill(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof ServerPlayerEntity && !(event.getSource().func_76346_g() instanceof FakePlayer)) {
            if (this.killTasks == null) {
                this.killTasks = ServerQuestFile.INSTANCE.collect(KillTask.class);
            }
            if (this.killTasks.isEmpty()) {
                return;
            }
            ServerPlayerEntity player = (ServerPlayerEntity)event.getSource().func_76346_g();
            PlayerData data = ServerQuestFile.INSTANCE.getData((Entity)player);
            for (KillTask task : this.killTasks) {
                TaskData taskData = data.getTaskData(task);
                if (taskData.progress >= task.getMaxProgress() || !data.canStartTasks(task.quest)) continue;
                ((KillTask.Data)taskData).kill(event.getEntityLiving());
            }
        }
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K && ServerQuestFile.INSTANCE != null) {
            if (this.autoSubmitTasks == null) {
                this.autoSubmitTasks = ServerQuestFile.INSTANCE.collect(Task.class, o -> o instanceof Task && ((Task)o).autoSubmitOnPlayerTick() > 0);
            }
            if (this.autoSubmitTasks.isEmpty()) {
                return;
            }
            PlayerData data = ServerQuestFile.INSTANCE.getData((Entity)event.player);
            long t = event.player.field_70170_p.func_82737_E();
            for (Task task : this.autoSubmitTasks) {
                TaskData taskData;
                long d = task.autoSubmitOnPlayerTick();
                if (d <= 0L || t % d != 0L || (taskData = data.getTaskData(task)).isComplete() || !data.canStartTasks(task.quest)) continue;
                taskData.submitTask((ServerPlayerEntity)event.player);
            }
        }
    }

    private void livingDrops(LivingDropsEvent event) {
        LivingEntity e = event.getEntityLiving();
        if (e.field_70170_p.field_72995_K || e instanceof PlayerEntity) {
            return;
        }
        if (ServerQuestFile.INSTANCE == null || !ServerQuestFile.INSTANCE.dropLootCrates) {
            return;
        }
        LootCrate crate = ServerQuestFile.INSTANCE.getRandomLootCrate((Entity)e, e.field_70170_p.field_73012_v);
        if (crate != null) {
            ItemEntity ei = new ItemEntity(e.field_70170_p, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), crate.createStack());
            ei.func_174867_a(10);
            event.getDrops().add(ei);
        }
    }

    private void itemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity && !event.getCrafting().func_190926_b()) {
            FTBQuestsInventoryListener.detect((ServerPlayerEntity)event.getPlayer(), event.getCrafting());
        }
    }

    private void itemSmelted(PlayerEvent.ItemSmeltedEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity && !event.getSmelting().func_190926_b()) {
            FTBQuestsInventoryListener.detect((ServerPlayerEntity)event.getPlayer(), event.getSmelting());
        }
    }

    private void cloned(PlayerEvent.Clone event) {
        event.getPlayer().field_71069_bz.func_75132_a((IContainerListener)new FTBQuestsInventoryListener((ServerPlayerEntity)event.getPlayer()));
        if (!event.isWasDeath()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        PlayerEntity oldPlayer = event.getOriginal();
        if (player instanceof FakePlayer || player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            return;
        }
        for (int i = 0; i < oldPlayer.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)oldPlayer.field_71071_by.field_70462_a.get(i);
            if (stack.func_77973_b() != FTBQuestsItems.BOOK || !player.func_191521_c(stack)) continue;
            oldPlayer.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    private void dropsEvent(LivingDropsEvent event) {
        if (!(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        if (player instanceof FakePlayer || player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            return;
        }
        Iterator iterator = event.getDrops().iterator();
        while (iterator.hasNext()) {
            ItemEntity drop = (ItemEntity)iterator.next();
            ItemStack stack = drop.func_92059_d();
            if (stack.func_77973_b() != FTBQuestsItems.BOOK || !player.func_191521_c(stack)) continue;
            iterator.remove();
        }
    }

    private void changedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            PlayerData data = ServerQuestFile.INSTANCE.getData((Entity)event.getPlayer());
            for (DimensionTask task : ServerQuestFile.INSTANCE.collect(DimensionTask.class)) {
                data.getTaskData(task).submitTask((ServerPlayerEntity)event.getPlayer());
            }
        }
    }

    private void containerOpened(PlayerContainerEvent.Open event) {
        if (event.getPlayer() instanceof ServerPlayerEntity && !(event.getContainer() instanceof PlayerContainer)) {
            event.getContainer().func_75132_a((IContainerListener)new FTBQuestsInventoryListener((ServerPlayerEntity)event.getPlayer()));
        }
    }
}

