/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftbquests.FTBQuestsCommon;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.client.FTBQuestsClientEventHandler;
import com.feed_the_beast.ftbquests.client.QuestFileCacheReloader;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.ItemReward;
import com.feed_the_beast.ftbquests.quest.reward.XPLevelsReward;
import com.feed_the_beast.ftbquests.quest.reward.XPReward;
import com.feed_the_beast.ftbquests.quest.task.DimensionTask;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.FluidTask;
import com.feed_the_beast.ftbquests.quest.task.ItemTask;
import com.feed_the_beast.ftbquests.quest.task.LocationTask;
import com.feed_the_beast.ftbquests.quest.theme.ThemeLoader;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigFluid;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigFromString;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigInt;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigItemStack;
import com.feed_the_beast.mods.ftbguilibrary.config.Tristate;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfig;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfigFromString;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiSelectFluid;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiSelectItemStack;
import com.feed_the_beast.mods.ftbguilibrary.utils.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.ItemHandlerHelper;

public class FTBQuestsClient
extends FTBQuestsCommon {
    private static final Pattern I18N_PATTERN = Pattern.compile("\\{([a-zA-Z0-9\\._\\-]*?)\\}", 8);
    public static KeyBinding KEY_QUESTS;

    public static String addI18nAndColors(String text) {
        if (text.isEmpty()) {
            return text;
        }
        Matcher i18nMatcher = I18N_PATTERN.matcher(text);
        while (i18nMatcher.find()) {
            i18nMatcher.reset();
            StringBuffer sb = new StringBuffer(text.length());
            while (i18nMatcher.find()) {
                i18nMatcher.appendReplacement(sb, I18n.func_135052_a((String)i18nMatcher.group(1), (Object[])new Object[0]));
            }
            i18nMatcher.appendTail(sb);
            text = sb.toString();
            i18nMatcher = I18N_PATTERN.matcher(text);
        }
        if (StringUtils.unformatted((String)(text = StringUtils.addFormatting((String)text.trim()))).isEmpty()) {
            return "";
        }
        return text;
    }

    @Override
    public void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)new QuestFileCacheReloader());
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)new ThemeLoader());
        new FTBQuestsClientEventHandler().init();
    }

    private void setup(FMLClientSetupEvent event) {
        KEY_QUESTS = new KeyBinding("key.ftbquests.quests", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM, -1, "key.categories.ftbquests");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_QUESTS);
    }

    @Override
    public QuestFile getQuestFile(IWorld world) {
        return world.func_201670_d() ? ClientQuestFile.INSTANCE : ServerQuestFile.INSTANCE;
    }

    @Override
    @Nullable
    public QuestFile getQuestFile(Tristate clientSide) {
        if (clientSide.isDefault()) {
            return this.getQuestFile(EffectiveSide.get().isClient() ? Tristate.TRUE : Tristate.FALSE);
        }
        return clientSide.isTrue() ? ClientQuestFile.INSTANCE : ServerQuestFile.INSTANCE;
    }

    @Override
    public void setTaskGuiProviders() {
        FTBQuestsTasks.ITEM.setGuiProvider((gui, quest, callback) -> {
            ConfigItemStack c = new ConfigItemStack(false, false);
            c.defaultValue = ItemStack.field_190927_a;
            c.value = ItemStack.field_190927_a;
            new GuiSelectItemStack(c, accepted -> {
                gui.run();
                if (accepted) {
                    ItemTask itemTask = new ItemTask(quest);
                    itemTask.item = ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)c.value), (int)1);
                    itemTask.count = ((ItemStack)c.value).func_190916_E();
                    callback.accept(itemTask);
                }
            }).openGui();
        });
        FTBQuestsTasks.FLUID.setGuiProvider((gui, quest, callback) -> {
            ConfigFluid c = new ConfigFluid(false);
            c.defaultValue = Fluids.field_204541_a;
            c.value = Fluids.field_204541_a;
            new GuiSelectFluid(c, accepted -> {
                gui.run();
                if (accepted) {
                    FluidTask fluidTask = new FluidTask(quest);
                    fluidTask.fluid = (Fluid)c.value;
                    callback.accept(fluidTask);
                }
            }).openGui();
        });
        FTBQuestsTasks.DIMENSION.setGuiProvider((gui, quest, callback) -> {
            DimensionTask task = new DimensionTask(quest);
            task.dimension = String.valueOf(Minecraft.func_71410_x().field_71439_g.field_71093_bK.getRegistryName());
            callback.accept(task);
        });
        FTBQuestsTasks.LOCATION.setGuiProvider((gui, quest, callback) -> {
            TileEntity tileEntity;
            LocationTask task = new LocationTask(quest);
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71476_x instanceof BlockRayTraceResult && (tileEntity = mc.field_71441_e.func_175625_s(((BlockRayTraceResult)mc.field_71476_x).func_216350_a())) instanceof StructureBlockTileEntity) {
                BlockPos pos = ((StructureBlockTileEntity)tileEntity).func_189711_e();
                BlockPos size = ((StructureBlockTileEntity)tileEntity).func_189717_g();
                task.dimension = String.valueOf(mc.field_71439_g.field_71093_bK.getRegistryName());
                task.x = pos.func_177958_n() + tileEntity.func_174877_v().func_177958_n();
                task.y = pos.func_177956_o() + tileEntity.func_174877_v().func_177956_o();
                task.z = pos.func_177952_p() + tileEntity.func_174877_v().func_177952_p();
                task.w = Math.max(1, size.func_177958_n());
                task.h = Math.max(1, size.func_177956_o());
                task.d = Math.max(1, size.func_177952_p());
                callback.accept(task);
                return;
            }
            ConfigGroup group = new ConfigGroup("ftbquests");
            task.getConfig(task.createSubGroup(group));
            group.savedCallback = accepted -> {
                gui.run();
                if (accepted) {
                    callback.accept(task);
                }
            };
            new GuiEditConfig(group).openGui();
        });
    }

    @Override
    public void setRewardGuiProviders() {
        FTBQuestsRewards.ITEM.setGuiProvider((gui, quest, callback) -> {
            ConfigItemStack c = new ConfigItemStack(false, false);
            c.defaultValue = ItemStack.field_190927_a;
            c.value = ItemStack.field_190927_a;
            new GuiSelectItemStack(c, accepted -> {
                if (accepted) {
                    callback.accept(new ItemReward(quest, (ItemStack)c.value));
                }
                gui.run();
            }).openGui();
        });
        FTBQuestsRewards.XP.setGuiProvider((gui, quest, callback) -> {
            ConfigInt c = new ConfigInt(1, Integer.MAX_VALUE);
            GuiEditConfigFromString.open((ConfigFromString)c, (Object)100, (Object)100, accepted -> {
                if (accepted) {
                    callback.accept(new XPReward(quest, (Integer)c.value));
                }
                gui.run();
            });
        });
        FTBQuestsRewards.XP_LEVELS.setGuiProvider((gui, quest, callback) -> {
            ConfigInt c = new ConfigInt(1, Integer.MAX_VALUE);
            GuiEditConfigFromString.open((ConfigFromString)c, (Object)5, (Object)5, accepted -> {
                if (accepted) {
                    callback.accept(new XPLevelsReward(quest, (Integer)c.value));
                }
                gui.run();
            });
        });
    }

    @Override
    public PlayerData getClientPlayerData() {
        return ClientQuestFile.INSTANCE.getData((Entity)Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public QuestFile createClientQuestFile() {
        return new ClientQuestFile();
    }
}

