/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.net.MessageGetEmergencyItems;
import com.feed_the_beast.ftbquests.quest.QuestShape;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.utils.StringUtils;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetLayout;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class GuiEmergencyItems
extends GuiBase {
    private long endTime;
    private boolean done;
    private final SimpleTextButton cancelButton;
    private final Panel itemPanel;

    public GuiEmergencyItems() {
        this.endTime = System.currentTimeMillis() + (long)ClientQuestFile.INSTANCE.emergencyItemsCooldown * 1000L;
        this.done = false;
        this.cancelButton = new SimpleTextButton((Panel)this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), (Icon)Icon.EMPTY){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                this.getGui().closeGui();
            }
        };
        this.itemPanel = new Panel((Panel)this){

            public void addWidgets() {
                for (ItemStack stack : ClientQuestFile.INSTANCE.emergencyItems) {
                    this.add(new EmergencyItem(this, stack));
                }
            }

            public void alignWidgets() {
                this.setWidth(this.align((WidgetLayout)new WidgetLayout.Horizontal(3, 7, 3)));
                this.setHeight(22);
                this.setPos((GuiEmergencyItems.this.width - ((GuiEmergencyItems)GuiEmergencyItems.this).itemPanel.width) / 2, GuiEmergencyItems.this.height * 2 / 3 - 10);
            }
        };
    }

    public void addWidgets() {
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.cancelButton);
        this.cancelButton.setPos((this.width - this.cancelButton.width) / 2, this.height * 2 / 3 + 16);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        long left = this.endTime - System.currentTimeMillis();
        if (left <= 0L) {
            if (!this.done) {
                this.done = true;
                this.cancelButton.setTitle(I18n.func_135052_a((String)"gui.close", (Object[])new Object[0]));
                new MessageGetEmergencyItems().sendToServer();
            }
            left = 0L;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((int)((float)w / 2.0f)), (float)((int)((float)h / 5.0f)), (float)0.0f);
        RenderSystem.scalef((float)2.0f, (float)2.0f, (float)1.0f);
        String s = I18n.func_135052_a((String)"ftbquests.file.emergency_items", (Object[])new Object[0]);
        theme.drawString(s, (float)(-theme.getStringWidth(s)) / 2.0f, 0.0f, Color4I.WHITE, 0);
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((int)((float)w / 2.0f)), (float)((int)((float)h / 2.5f)), (float)0.0f);
        RenderSystem.scalef((float)4.0f, (float)4.0f, (float)1.0f);
        s = left <= 0L ? "00:00" : StringUtils.getTimeString((long)(left / 1000L * 1000L + 1000L));
        int x1 = -theme.getStringWidth(s) / 2;
        theme.drawString(s, (float)(x1 - 1), 0.0f, Color4I.BLACK, 0);
        theme.drawString(s, (float)(x1 + 1), 0.0f, Color4I.BLACK, 0);
        theme.drawString(s, (float)x1, 1.0f, Color4I.BLACK, 0);
        theme.drawString(s, (float)x1, -1.0f, Color4I.BLACK, 0);
        theme.drawString(s, (float)x1, 0.0f, Color4I.WHITE, 0);
        RenderSystem.popMatrix();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private static class EmergencyItem
    extends Widget {
        private final ItemStack stack;

        public EmergencyItem(Panel p, ItemStack is) {
            super(p);
            this.setY(3);
            this.stack = is;
            this.setSize(16, 16);
        }

        public void addMouseOverText(List<String> list) {
            ArrayList list1 = new ArrayList();
            GuiHelper.addStackTooltip((ItemStack)this.stack, list1);
            for (ITextComponent t : list1) {
                list.add(t.func_150254_d());
            }
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            QuestShape.RSQUARE.outline.draw(x - 3, y - 3, w + 6, h + 6);
            GuiHelper.drawItem((ItemStack)this.stack, (int)x, (int)y, (boolean)true);
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.stack;
        }
    }
}

